#ident	"@(#)mvwdrvd.h	1.2	90/08/08"
#ifndef _SYS_MVWDRVD_H
#define _SYS_MVWDRVD_H
#ident "@(#) mvwdrvd.h 22.1 90/01/15 "
#ident "@(#)mvwdrvd.h	1.2 89/09/29"
#ident "@(#) mvwdrvd.h 1.2 89/07/21 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 */

/*
 *	Copyright (C) JSB Computer Systems Ltd, 1988.
 *
 *	This Module contains Proprietary Information of
 *	JSB Computer Systems Ltd, and should be treated
 *	as Confidential.
 */

#ifndef                        PTTYD_DEFINED
#define PTTYD_DEFINED 1

#include "sys/mvwversion.h"

#ifdef                                          XENIX_3

#include "param.h"
#include "conf.h"
#include "dir.h"
#include "user.h"
#include "proc.h"
#include "tty.h"
#include "systm.h"
#include "file.h"
#include "signal.h"

#ifndef SCO_23
#include "ioctl.h"
#endif

#include "buf.h"
#ifndef                                         KDS_SEL
#include "mmu.h"
#endif

#ifdef ALTOS
#include "var.h"
#endif

#endif  /* XENIX_3 */

#ifdef                                          XENIX_5

#include "types.h"
#include "signal.h"
#if                                         ! ( SPRITE286 || NTAOC )
#include "errno.h"
#endif
#include "param.h"
#include "conf.h"
#include "dir.h"
#ifdef                                          XENIX_386
#include "page.h"
#include "seg.h"
#endif
#include "user.h"
#include "proc.h"
#include "tty.h"
#include "systm.h"
#include "file.h"
#include "ioctl.h"
#include "buf.h"
#include "var.h"
#ifndef                                         NTAOC
#include "sysmacros.h"
#endif
#ifndef                                         KDS_SEL
#include "mmu.h"
#endif
#ifdef                                          SCO_222
#include "emap.h"
#ifdef                                          VPIX
#include "v86.h"
#endif
#endif

#endif  /* XENIX_5 */

#ifdef                                          SYSV

#ifdef                                          M6300
#define defined_io 1
#endif
#include "sys/types.h"
#include "sys/errno.h"
#include "sys/ioctl.h"
#include "sys/buf.h"
#include "sys/var.h"
#include "sys/sysmacros.h"
#include "sys/termio.h"
#include "sys/signal.h"
#include "sys/param.h"
#include "sys/conf.h"
#include "sys/dir.h"

#if 	(ATT3B2 || UNI6000 || MOTOROLA || MICRO386 || ALT_V3_386 || M_S_UNIX)
#include "sys/immu.h"
#include "sys/region.h"
#ifdef                                          MICRO386
#include "kd_info.h"
#endif
#endif

#ifdef						UNI6000
#include "sys/spl.h"
#define spl5() spltty()
#endif

#ifdef                                          M68020
#include "net.h"
#include "page.h"
#endif

#ifdef						ATT3B2
#include "psw.h"
#include "pcb.h"
#endif

#include "sys/user.h"

#ifndef                                         INTERACTIVE
#include "sys/proc.h"
#endif

#include "sys/tty.h"

#ifndef						AIX
#include "sys/ttold.h"
#endif

#include "sys/systm.h"
#include "sys/file.h"

#ifdef						INTERACTIVE
#include "immu.h"
#include "region.h"
#include "at_ansi.h"
#include "kd.h"
#include "proc.h"
#endif

#ifdef						VPIX
#include "sys/tss.h"
#include "sys/v86.h"
#ifndef						M_S_UNIX
#include "asy.h"
#endif	/* M_S_UNIX */
#endif

#ifdef						M_S_UNIX
#include "sys/emap.h"
#include "sys/console.h"
#include <sys/sio.h>
#endif

#endif  /* SYSV */

#ifdef                                          FAR_KDS
typedef struct iosrtty far * RTTYPTR;
typedef struct iosptty far * PTTYPTR;
typedef struct iosmdev far * MDEVPTR;
typedef dev_t          far * MVWDEVTP;
#else
typedef struct iosrtty     * RTTYPTR;
typedef struct iosptty     * PTTYPTR;
typedef struct iosmdev     * MDEVPTR;
typedef short              * MVWDEVTP;
#endif                                       /* FAR_KDS */

#ifdef                                          FARPTR
typedef faddr_t              MVWADDR;
#else
typedef char *              MVWADDR;
#endif                                       /* FARPTR */

typedef struct tty          * TTYPTR;

#include "mvwtk.h"     /* toolkit driver header file */

#ifdef                                          DEBUG
#define PRINTF(a)    printf(a)
#else
#define PRINTF(a)    /* */
#endif

#define CR  015
#define LF  012
#define BS  010
#define TAB 011
#ifndef CLESC
#define CLESC ESC  /* for XENIX_3 */
#endif

#define MVW_SETUP        (('I'<<8) | 1)
#define MVW_FREE         (('I'<<8) | 2)

#define MVW_unused3      (('I'<<8) | 3)
#define MVW_IPSEQS       (('I'<<8) | 4)
#define MVW_SETD         (('I'<<8) | 5)
#define MVW_INIT         (('I'<<8) | 6)
#define MVW_KBDFOCUS     (('I'<<8) | 7)

#define MVW_RUNWIN       (('I'<<8) | 8)
#define MVW_OPROUTE      (('I'<<8) | 9)
#define MVW_SUSPEND      (('I'<<8) | 10)
#define MVW_RESUME       (('I'<<8) | 11)

#define MVW_CHK_IPQ      (('I'<<8) | 12)
#define MVW_POLL_EVENTS  (('I'<<8) | 13)

#define MVW_APPRQ        (('I'<<8) | 14)
#define MVW_NAP          (('I'<<8) | 15)
#define MVW_CHKCLOSED    (('I'<<8) | 16)

#define MVW_PAUSE        (('I'<<8) | 17)

#define MVW_HPRQID       (('I'<<8) | 18)

#if HW_ZOOM
#define MVW_ONBOARD      (('I'<<8) | 19)
#define MVW_OFFBOARD     (('I'<<8) | 20)
#endif

#define MVW_GET_VERSION  (('I'<<8) | 50)
#define MVW_CHKSERIALNO  (('I'<<8) | 51)
#define MVW_REGSERIALNO  (('I'<<8) | 52)

#define MVW_RTPDUMP      (('I'<<8) | 53)
#define MVW_PTPDUMP      (('I'<<8) | 54)
#define MVW_MDEVDUMP     (('I'<<8) | 55)

#define ALLDELAYS     (NLDLY | CRDLY | BSDLY | VTDLY | FFDLY)

#ifndef TTLOWAT		/* sometimes defined in tty.h -mmc */
#define TTLOWAT(tp)   (ttlowat[tp->t_cflag & CBAUD])
#endif
#ifndef TTHIWAT
#define TTHIWAT(tp)   (tthiwat[tp->t_cflag & CBAUD])
#endif

#ifndef                                         MIN
#define MIN(a,b)      (((a)<(b))?(a):(b))
#endif

#ifdef                                          FARPTR
#ifdef                                          CSEGB
#define COPYOUT(from, to, ct)     (copysegb(FADDR(KDS_SEL,from), to, ct))
#define COPYIN(from, to, ct)      (copysegb(from, FADDR(KDS_SEL,to), ct))
#define COPYBOUT(from, to)        (copysegb(FADDR(KDS_SEL,&from), to, 1))
#else
#ifdef                                          FAR_KDS
#define COPYOUT(from, to, ct)     (copyseg((faddr_t)from, to, ct))
#define COPYIN(from, to, ct)      (copyseg(from, (faddr_t)to, ct))
#define COPYBOUT(from, to)        (copyseg((faddr_t)&from, to, 1))
#else
#define COPYOUT(from, to, ct)     (copyseg(FADDR(KDS_SEL,from), to, ct))
#define COPYIN(from, to, ct)      (copyseg(from, FADDR(KDS_SEL,to), ct))
#define COPYBOUT(from, to)        (copyseg(FADDR(KDS_SEL,&from), to, 1))
#endif                                       /* FAR_KDS */
#endif                                       /* CSEGB */
#define COPYWIN(from, to)         (to = fuword((int far *)from))
#else                                        /* FARPTR */
#define COPYOUT(from, to, ct)     (copyout(from, to, ct))
#define COPYIN(from, to, ct)      (copyin(from, to, ct))
#define COPYBOUT(from, to)        (subyte(to, from))
#define COPYWIN(from, to)         (to = fuword((int *)from))
#endif                                       /* FARPTR */

#define COPYBIN(from, to)         (to = fubyte(from))

/* the following are the events which MVW_POLL_EVENTS can handle: */
#define     KBD_EVENT       1
#define     MSE_EVENT       2
#define     UI_EVENT        4
#define     HPTK_EVENT      8
#define     OP_EVENT        16
#define     RQ_EVENT        32
#define     BACK_EVENT      64
#define     XLP_EVENT       128

#define    kbd_event(rtp,scrtp)    (rtp->ios_line && \
                                    (scrtp->t_canq.c_cc || scrtp->t_rawq.c_cc))

#define    mse_event()             ()

#define    hptk_event(rtp)         (rtp->ios_rstate & \
                                    (HPTK_REQUEST | TK_OPEN_PENDING))

#define    ui_event(tkrttydp)      (tkrttydp->tk_uitty != (TTYPTR)0 && \
                                   (tkrttydp->tk_uitty->t_outq.c_cc || \
                                   (tkrttydp->tk_uiptty->tk_data.tk_req_state \
                                     & TK_RQREADY)))

#if					HW_ZOOM
#define    op_event(tp,ptp)        ((tp->t_outq.c_cc && \
				    ! (hwz_flags[tp - ios_tty] & HWZ_CAP_PTY_WRITE) && \
                                    !(ptp->ios_state & (TTSTOP | TBLOCK))) || \
                                                  !(ptp->ios_state & CARR_ON))
#else
#define    op_event(tp,ptp)        ((tp->t_outq.c_cc && \
                                    !(ptp->ios_state & (TTSTOP | TBLOCK))) || \
                                                  !(ptp->ios_state & CARR_ON))
#endif

#define    rq_event(ptp,tkpttydp)  (((ptp->ios_apprq || \
                                    (tkpttydp->tk_req_state & TK_RQREADY))) && \
                                    !(ptp->ios_state & (TTSTOP | TBLOCK)))
                                    
#define    xlpopen_event(rtp)      (rtp->ios_rstate & XLP_OPEN_PENDING)


/* the following are used by the MVW_KBDFOCUS ioctl: */
#define KBD_TO_MVIEW 0
#define KBD_TO_WIN   1

/* the following are the only valid bit settings of ios_mstate, other than 0: */
#define XLP                   1
#define SLV_OPEN_PENDING      2   /* slave open pending                       */
#define TK_PTY_TAKEN          4   /* This ptty formerly allocated by WIOCGTTY */
#define SLV_OPEN_FAIL         8   /* open failed                              */
#define XLP_CLOSING          16   /* xlp ptty currently closed                */

/* the following are the only valid bit settings of ios_rstate, other than 0: */
#define XLP_OPEN_PENDING      1   /* toolkit slave open pending               */
#define TK_OPEN_PENDING       2   /* xparent printer open pending             */
#define HPTK_REQUEST          4   /* high priority toolkit request pending    */

/* Used as a paramater to mvw_setproc(): */
#define SET_FOR_PSEUDO        1
#define SET_FOR_REAL          2

struct iosrtty     /* per real tty data */
{
    struct tty    *ios_realtty;
    struct proc   *ios_procptr;
    short         ios_rstate;
    short         ios_line;
    short         ios_oline;
    dev_t         ios_slot;
    dev_t         kbd_dev;
    dev_t         realdev;
    char          disp_adapter;
    char          xon;
    char          mdevs[MAX_NWPT];
    ushort        ios_ip1lo;
    ushort        ios_ip1hi;
    ushort        ios_ip2lo;
    ushort        ios_ip2hi;
    long          ios_serialno;
    TK_RTTY_DATA  tk_data;
};

                   /* per pseudo tty data - may be in far data segment on
                      Xenix, so doesn't include actual tty structure      */
struct iosptty
{
    short         ios_state;
    dev_t         ios_minor;
    char          ios_apprq;
    char          ios_opdirect;
    TK_PTTY_DATA  tk_data;
};

struct iosmdev
{
    char ios_rtidx;
    char ios_ptidx;
    char ios_mstate;
};

#ifdef                                      ALT_V3_386
#define  sleep(a,b)  msleep((mplock_t *)0,a,b)
#endif
#ifdef                                      SCO_222
#define  spltty()    spl5()
#endif

/* Here is code specific to VPIX on SCO Xenix:  */
#ifdef                              SCO_222
#ifdef                              VPIX
typedef  dev_t (*dev_t_funcp_t)();
#endif
#endif

#ifndef                                         XENIX_5
#define mvw_getminor(mdev, dev)      mdev = minor(dev)
#else
#define mvw_getminor(mdev, dev)      mdev = dev
#endif

/*
 * The 'ifdefs' in the driver source code are as follows :
 
 * SYSV   - this is UNIX V (or at least similar enough for our purposes)
 * XENIX_3  - this is XENIX 3
 * XENIX_5  - this is XENIX V

 * FARPTR   - ioctl calls need to explicitly specify parameter addresses as far
              (Intel 286 technology).

 * FAR_KDS  - there's an extra kernel data segment in play.  If this is the
              case, most of our data goes in there.  So far, this is specific
              to SCO Xenix V 2.2.2.

 * IDD      - the kernel uses self-installable device drivers, so we need to 
              specify a set of functions at the top of controller & slave.

 * the following are system variant specifics.
 * VIENNA   
 * M6300
 * UNIPLUS

 * KDS_SEL   - this is used in our definitions include file to make sure
               that we get the kernel data segment selector right on 286
               boxes.  We don't need to specify this in compilation - it's
               implicit, and only comes into play if we can't find the right
               value from the usual system include files.
 */
#endif

#endif	/* _SYS_MVWDRVD_H */
