/*
 *	@(#) mmu.h 2.3 88/05/18 
 *
 *	Copyright (C) The Santa Cruz Operation, 1984, 1985, 1986, 1987.
 *	Copyright (C) Microsoft Corporation, 1984, 1985, 1986, 1987.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 */

#ifdef M_I386

#define	MMUERR ((int)-1)

#define INVALID ((caddr_t)-1)

/* bytes to memory size (page/click) */
#define btoms(x)	btoc(x)

/* memory size (click/page) to bytes */
#define mstob(x)	ctob(x)
#define mltoa(x)	ctob(x)

/* number of pages in a segment (used for setting baseaddr of 286 ldts) */
#define NPGS		17

/* memory size to disk blocks */
#define mstod(x)	(ctob(x)/BSIZE)

/* convert segment:offset 8086 far pointer to address */
#define ftop(x)	(((x & 0xffff0000) >> 12) + (x & 0xffff))

/*
 * defines for 286 compatibility
 */
#define	MMPGSZ	512		/* bytes/page in the MMU */
#define	LMMPGSZ	9		/* log2(MMPGSZ) */
#define NPAGEPS	128		/* 64k/MMPGSZ = number of pages per segment */

/* mem size to bytes */
#define	mstob286(x)	((x)<<LMMPGSZ)

/* bytes to mem size */
#define	btoms286(x)      ((unsigned) (((long)(x) + (MMPGSZ-1)) >> LMMPGSZ))

#else

/*
 * mmu.h
 *	Memory Management Definitions
 *
 * used by mmu.c
 * param.h has basic page-size/etc definitions.
 *
 * definitions for 286/8086 memory managment model
 *
 */

#ifdef M_I8086
extern short mm_size;		/* #mem pages initialized to NCOREL */

#define	RO	0
#define	RW	1

#define	MMUERR	-1		/* error return from MMU routines */
#define	MMUOK	0		/* normal return from MMU routines */

#define	SEGKD	0

#define	SEGUD	(u.u_usegs[0])
#define	SEGUI	(u.u_usegs[1])
#endif /* M_I8086 */

#define NDSEGS	3	/* number of data segments the kernel may have*/
#define NCSEGS	7	/* number of text segments the kernel may have*/

#include "relsym86.h"

#define SELSZ		sizeof(struct desctab)

#ifdef M_I286

#define	NBUFSEL	16	/* number of selectors for mapped out buffers */

/*
 * descriptor table defines
 * NOTE: the RPL in USEG_SEL and ULDT_SEL is 0. This
 *	 does not ENFORCE protection
 */
#define	NULL_SEL	0	/* 'invalid' selector */
/* 
 * portable gdt defines
 * WARNING - these must agree with the layout of the gdt in oem.c
 */
#define	GDT_SEL		0x8	/* selector for GDT alias */
#define	IDT_SEL		0x10	/* selector for IDT alias */
#define KDS_SEL		0x18	/* 1st kernel data seg selector */
#define	KCS_SEL		0x30	/* 1st kernel code seg selector */
#define	KSS_SEL		0x68	/* kernel stack seg selector */
#define	KTSS		0x70	/* kernel TSS selector */
#define	SFTSS		0x78	/* stack fault TSS selector */
#define	KWORK0		0x80	/* work segment selector */
#define	KWORK1		0x88	/* work segment selector */
#define	KWORK2		0x90	/* work segment selector */
#define	MAPWKSEL	0x98	/* selector for map work */
#define COPY_SEL	0xA0	/* selector for copyio */
#define	CLDT_SEL	0xA8	/* current process' ldt selector */
#define	KENTRY		0xB0	/* kernel entry selector (call gate) */
				/* 0xB8 and 0xC0 reserved */
#define BUF_SEL		0xC8	/* 1st of 16 selectors to map buffers */
#define	SWAP1_SEL	0x148	/* work segment selector - swap */
#define	SWAP2_SEL	0x150	/* work segment selector - swap */
#define	SWAP3_SEL	0x158	/* work segment selector - swap */
#define	SWAP4_SEL	0x160	/* work segment selector - swap */
#define FREE_SEL	0x168	/* 1st dscralloc() selector */

#define NGDT	(stoi(FREE_SEL)+1 + 40)	   /*  86 ; 40 dscralloc() selectors */

/* 
 * ldt defines 
 * These selector definitions should not be touched - they are chip
 * and linker defined
 */
#define	USEG_SEL	0x04	/* LDT based U seg selector */
#define	ULDT_SEL	0x0C	/* ldt based, ldt alias */
#define	ULINFO_SEL	0x14	/* used for ldt info array */
#define UEXEC_SEL	0x1C	/* used during an exec */
#define	ULDTTMP_SEL	0x24	/* used for execing and in mmu routines */
#define	UTEMP_SEL	0x2C	/* used for swapping, etc */
#define	UOVRLY_SEL	0x34	/* used with overlay files */
#define	FIRSTU_SEL	0x3F	/* user's initial selector */

#define LDTPAD		8	/* number extra ldt slots allocated per proc */					/* size of an ldt entry in bytes (8) */
#define MAXLDT		8192	/* maximum number of entries in an ldt */
#define KERNLDT	 	7	/* number of kernel reserved ldts */

#define IDTSZ		256			/* number of entries in idt */
#define IDTLIM		(IDTSZ * SELSZ) -1	/* idt limit */

/*
 * Descriptor Types
 */
#define	DST_ATASK	0x1	/* avail task */
#define	DST_TABLE	0x2	/* descriptor table */
#define	DST_BTASK	0x3	/* busy task */
#define	DST_CGATE	0x4	/* call gate */
#define	DST_TAGATE	0x5	/* task context gate */
#define	DST_IGATE	0x6	/* interrupt gate */
#define	DST_TRGATE	0x7	/* trap gate */

/*
 * access byte fields (DSA_*) are defined in relsym86.h
 */


/*
 * tss structure
 */

struct tss {
	unsigned	t_link;		/* previous tss selector */
	unsigned	t_sp0;		/* stack for level 0 */
	unsigned	t_ss0;
	unsigned	t_sp1;		/* stack for level 1 */
	unsigned	t_ss1;
	unsigned	t_sp2;		/* stack for level 2 */
	unsigned	t_ss2;
	unsigned	t_ip;		/* task state - ip */
	unsigned	t_flags;	/* task state - flags */
	unsigned	t_ax;		/* task state - ax */
	unsigned	t_cx;		/* task state - cx */
	unsigned	t_dx;		/* task state - dx */
	unsigned	t_bx;		/* task state - bx */
	unsigned	t_sp;		/* task state - sp */
	unsigned	t_bp;		/* task state - bp */
	unsigned	t_si;		/* task state - si */
	unsigned	t_di;		/* task state - di */
	unsigned	t_es;		/* task state - es */
	unsigned	t_cs;		/* task state - cs */
	unsigned	t_ss;		/* task state - ss */
	unsigned	t_ds;		/* task state - ds */
	unsigned	t_ldt;		/* task ldt selector */
};

#define TSSLIM		(sizeof(struct tss) - 1) 	/* tss limit */

/*
 * flag register bits
 */
#define	FL_NCX		0x4000	/* nested context */
#define	FL_IOPL		0x3000	/* I/O priv level */
#define	FL_OFLOW	0x800	/* overflow bit */
#define	FL_DIR		0x400	/* direction of string ops */
#define	FL_INTEN	0x200	/* interrupt enable */
#define	FL_TRAP		0x100	/* single step flag */
#define	FL_SIGN		0x80	/* sign bit */
#define	FL_ZERO		0x40	/* zero bit */
#define	FL_AUXCARRY	0x10	/* auxillary carry */
#define	FL_PARITY	0x4	/* parity bit */
#define	FL_CARRY	0x1	/* carry bit */

/*
 * parts of a selector see relsym86.h
 */
#define	SEL_TI		SEL_LDT	/* table indicator (0-gdt,1-ldt) */

/*
 * descriptor table structure: see relsym86.h
 */
#define NPSEGM	0		/* no segments */

/*
 * Misc constants.
 */
#define OFFMASK	(MMPGSZ-1)	/* develop offset within page from addr */

#define RO (DSA_CODE|DSA_RING3) /* tells mmuset to setup code to make */
#define RW (DSA_DATA|DSA_RING3) /* kernel access read-only, or rd/wr */

#define	MMUOK	((mloc_t) 0)
#define	MMUERR	((mloc_t) -1)

struct ldtinf {
	unsigned short flag;
	union {
		unsigned short psize;	/* used for exec */
		unsigned short swapbn;	/* block # on swapper */
		unsigned short dupsel;	/* sel this sel is dup of, if LT_DUP */
	} si;
};

/* 
 * ldtinf flag values indicating the type of segment represented
 */

#define LT_OWN		0x0001		/* maps user-owned, private memory */
#define LT_ALLOC	0x0002		/* swapper must allocate mem for exec */
#define LT_EXPAND	0x0004		/* expanding segment -used by swapper */
#define LT_ITER		0x0008		/* iterated data or text segment */
#define LT_SD		0x0010		/* shared data segment */
#define LT_ABS		0x0020		/* maps fixed location (i.e. screen) */
#define LT_DUP		0x0040		/* duplicate mapping */
#define LT_EXEC		0x0080		/* executable segment */
#define LT_RO		0x0100		/* read-only segment */
#define LT_HUGE		0x0200		/* allocated as HUGE seg by brkctl */
#define LT_CONTIG	0x0400		/* maps a segment in a series */
					/*  of physically contiguous segments */
#define LT_FCONTIG	0x0800		/* first in a series of physically */
					/* contiguous segments */

extern fdesc_t *ldt;			/* ULDT_SEL:0 */
#define	flinf_t		struct ldtinf far	/* far ldt info array entry */
extern flinf_t *ldtinfo;		/* ULINFO_SEL:0 */
#ifndef NOEXTGDT
extern struct desctab gdt[];
#endif

extern mloc_t mmupget();
extern mloc_t mmuget();

/*
 * LDTDESCR initializes an ldt entry
 */
#define LDTDESCR(sel, addr, limit, access)	\
if (1) {					\
	int xacc = access;			\
	fdesc_t *_p = &ldt[sel/SELSZ];		\
	_p->d_limit = limit;			\
	_p->d_paddr = addr;			\
	_p->d_acc = xacc;			\
} else

/*
 * GDTDESCR initializes a gdt entry
 */
#define GDTDESCR(sel, addr, limit, access)	\
if (1) {					\
	int xacc = access;			\
	struct desctab *_p = &gdt[sel/SELSZ];	\
	_p->d_limit = limit;			\
	_p->d_paddr = addr;			\
	_p->d_acc = xacc;			\
} else

#endif /* M_I286 */
#endif /* M_I386 */
