/*
 *	@(#) kmon.h 2.1 88/05/18 
 *
 *	Copyright (C) The Santa Cruz Operation, 1984, 1985, 1986, 1987.
 *	Copyright (C) Microsoft Corporation, 1984, 1985, 1986, 1987.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 */

/*
 *  Monitor buffer starts with the following structure:
 */
struct monhdr {
	int		(far *mh_lowpc)();	/* lowest address */
	int		(far *mh_highpc)();	/* highest address */
	unsigned short	mh_nfunc;		/* number of procedures */
};

/*
 *  and is followed by an array of monhdr->mh_nfunc of:
 */
struct mon {
	long	m_count;		/* number of invocations */
	int	(far *m_proc)();	/* procedure address */
};

/*
 *  and then by an array of shorts.
 */

/*
 *  definitions for kernel monitor control
 */
#define	KMON		1
#define	KMON_ON		64
#define	KMON_OFF	65
#define	KMON_DUMP	66
#define	KMON_RESET	67
#define	KMON_TEST	68
