#ident	"@(#)ivlab.h	1.2	90/08/08"
#ifndef _SYS_IVLAB_H
#define _SYS_IVLAB_H
#ident "@(#) ivlab.h 22.1 90/01/15 "
#ident "@(#)ivlab.h	1.2 89/09/29"
#ident "@(#) ivlab.h 1.6 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* #ident	"@)#(head.sys:ivlab.h	1.3" */

/*
 *	iRMX 86 Volume Label Definitions for UNIX.
 *
 * This is used to keep a UNIX Volume close enough to RMX 86 to
 * allow use of various RMX 86 technology (ie, PROM bootstrap drivers).
 *
 */

union   v_part {
	struct  {
		ushort  v_part_st;
		ushort  v_part_sz;
		ushort  v_part_sid;
		} vp_std;               /* standard partition def */
	struct  {
		ushort  v_sanity_l;     /* sanity to verify label (low half) */
		ushort  v_sanity_h;     /* high half of sanity */
		ushort  v_version;      /* label version number */
		} vp_sanity;            /* used for v_prt[1] */
	struct  {
		ushort  v_pd_sect_l;    /* low half of absolute sector number
					   of beginning of pdinfo structure */
		ushort  v_pd_sect_h;    /* high half of sector number */
		ushort  v_pd_len;       /* # of bytes in pdinfo block */
		} vp_pdinfo;            /* used for v_prt[2] */
};

#define VP_SANITY(ptr) ((((union v_part *)(ptr))->vp_sanity.v_sanity_h << 16)\
		       | (((union v_part *)(ptr))->vp_sanity.v_sanity_l))
#define VP_PD_SECT(ptr) ((((union v_part *)(ptr))->vp_pdinfo.v_pd_sect_h << 16)\
			| (((union v_part *)(ptr))->vp_pdinfo.v_pd_sect_l))
#define SET_VP_SANITY(ptr,val) ((union v_part *)(ptr))->vp_sanity.v_sanity_h\
				= (ulong)val >> 16;\
			       ((union v_part *)(ptr))->vp_sanity.v_sanity_l\
				= val & 0xffff;
#define SET_VP_PD_SECT(ptr,val) ((union v_part *)(ptr))->vp_pdinfo.v_pd_sect_h\
				 = (ulong)val >> 16;\
				((union v_part *)(ptr))->vp_pdinfo.v_pd_sect_l\
				  = val &0xffff;

struct	ivlab {
	char    v_name[10];     /* volume name, blank padded */
	char    v_flags;        /* flags byte -- see below */
	char    v_fdriver;      /* file-driver number */
	ushort  v_gran;         /* volume-gran (bytes) */
	ushort  v_size_l;       /* size (bytes) of volume (low) */
	ushort  v_size_h;       /* size (bytes) of volume (low) */
	ushort  v_maxfnode;     /* max fnode # (0 on UNIX) */
	ushort  v_stfnode_l;    /* start of fnodes (2 in UNIX)(low)*/
	ushort  v_stfnode_h;    /* start of fnodes (2 in UNIX)(high)*/
	ushort  v_szfnode;      /* size of fnode (32 in UNIX) */
	ushort  v_rfnode;       /* root fnode (2 in UNIX) */
	ushort  v_devgran;      /* sector size (bytes) */
	ushort  v_intl;         /* interleave; 0 ==> unknown */
	ushort  v_trskew;       /* track skew; 0 ==> none */
	ushort  v_sysid;        /* OS id for OS that formatted vol. */
	char    v_sysname[12];  /* OS name (as above), blank filled */
	char    v_dspecial[8];  /* device-special info (a drtab entry) */
	char    v_reserved[22]; /*      reserved for future use */
	ushort  v_fsdelta;      /* start of root filesystem on boot */
	long    v_fsofset;      /* start of ram filesystem on boot */
	long    v_ramfsloc;     /* location of start of ram disk.  */
	long    v_ramfssiz;     /* size of ram file system */
	ushort  v_filler;
	union v_part  v_prt[4]; /* four partitions */
	char    v_partno[10];   /* part number for IQC */
};

#define VLAB_SECT       0L      /* sector # of volume label on disk */
#define VLAB_START      384     /* byte # of volume label */
#define VLAB_FLOFF      10      /* flags field offset (for boot) */
#define VLAB_FSDOFF     78      /* fsdelta field offset (for boot ) */
#define VLAB_VALID      0xdeadfeeb  /* magic number for label sanity */
#define VP_SANITY_IDX   1       /* v_prt index for sanity stuff */
#define VP_PDINFO_IDX   2       /* v_prt index for pdinfo stuff */

/*
 * Flags byte definitions.
 */

#define VF_AUTO         0x01    /* 1 ==> byte is valid */
#define VF_DENSITY      0x02    /* 0 = FM, 1 = MFM */
#define VF_SIDES        0x04    /* 1 = double-sided */
#define VF_MINI         0x08    /* 0 = 8", 1 = 5.25" */
#define VF_NOT_FLOPPY   0x10    /* 0 = flop track 0 is 128 SD, 1 = not flop */

/*
 * Misc. other defintions.
 */

#define UNIX_FD         6       /* UNIX "file-driver" number;   */
				/* just to be different from RMX86 */
#define UNIX_SID        0x0040  /* UNIX "system-id" (as above) */

#endif	/* _SYS_IVLAB_H */
