#ident	"@(#)ir.h	1.2	90/08/08"
#ifndef _SYS_IR_H
#define _SYS_IR_H
#ident "@(#) ir.h 22.1 90/01/15 "
#ident "@(#)ir.h	1.2 89/09/29"
#ident "@(#) ir.h 1.3 89/07/27 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1988, 1989.
 *	Copyright (C) Archive Corporation, 1988.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and Archive Corporation,
 *	and should be treated as Confidential.
 */
/* Defines common to all Irwin drives */

/* Minor device bit definitions */

#define IR_OVERRIDE 0x80	/* control device */

/* number of entries in the new bad segment table */
#define IR_NBB	64

struct ir_nbbent {			/* new bad block entry */
	unsigned short seg;		/* segment number */
	unsigned long map;		/* segment map */
};

struct ir_newbbt {			/* new bad segment table */
	int	cnt;		/* # entries */
	struct ir_nbbent bbt[IR_NBB];	/* array of entries */
};

#define IR_SCTRSIZ 1024

struct ir_volume_table {
	unsigned char signature[4];
	unsigned short start;
	unsigned short end;
	unsigned char descr[44];
	unsigned long date;
	unsigned char flags;
	unsigned char sequence;
	unsigned char vendor[26];
	unsigned char passwd[8];
	unsigned long dirsize;
	unsigned long datasize;
	unsigned char OSvers[2];
	unsigned char label[16];
	unsigned char logdrv;
	unsigned char physdrv;
	unsigned char reserved[6];
	unsigned short bytes_in_last_segment;
};
typedef struct ir_volume_table ir_volume;
#ifdef M_I286
typedef ir_volume far *Pir_volume;
#else
typedef ir_volume *Pir_volume;
#endif

union ir_status {
	struct {
		unsigned short ready	: 1;	
		unsigned short eot   	: 1;	
		unsigned short bot   	: 1;	
		unsigned short cpres   	: 1;	
		unsigned short track	: 1;	
		unsigned short newc    	: 1;	
		unsigned short dc2k     : 1;	
		unsigned short spare    : 1;	

		unsigned short errnum : 8;	/* error number */
		unsigned short errcmd : 8;	/* error assoc. with cmd */

		unsigned short sfterr;		/* soft errors */
		unsigned short hrderr;		/* hard errors */
		unsigned short undrun;		/* underruns */
	} status;
	unsigned char stat[9];
};


struct btt {
unsigned short blks[254];	/* absolute bad block numbers		*/
unsigned short signature;	/* MUST be 0xAA55			*/
unsigned short checksum;	/* not presently used			*/
};

struct ir_header_fmt_record {
	unsigned char signature[4]; 	/* always 55 AA 55 AA */
	unsigned char fmt_code; 	/* always 02 */
	unsigned char unused;
	unsigned short segment; 		/* segment number of header segment */
	unsigned short dupsegment; 	/* seg num of duplicate header */
	unsigned short first;		/* first data segment number */
	unsigned short last;		/* last data segment number */
	unsigned char last_fmt_date[4];	/* date of last format */
	unsigned char last_write_date[4];	/* date of last write or format */
	unsigned char unused2[106];
	unsigned char fmt_error;	/* FF if remaining fields lost */
	unsigned char unused3;
	unsigned char lifetime[4];	/* +1 for every read,write,format */
	unsigned char unused4[4];
	unsigned char first_fmt_date[4];/* date of first format */
	unsigned short fmt_count;	/* times tape has been formatted */
	unsigned short failed_count;	/* number of entries in failed log */
	unsigned char mfr_code[44];	/* zero for non-pre-formatted */
	unsigned char mfr_lot[44];	/* zero for non-pre-formatted */
	unsigned char unused5[22];
	unsigned short fail_log[384];	/* log of sectors failed to verify */
};

/* This is the tape format that Irwin puts on their tapes. */

#pragma pack(1)

struct ir_sco_header {
	unsigned short first;
	unsigned short last;		/* block # of last data block */
	unsigned short start;
	unsigned short end;
	unsigned short last_count;	/* byte count of last block */
	char signature[32];		/* SCO UNIX or SCO XENIX */
	unsigned char unused[86];
};

struct ir_format_record {
	unsigned char message[45];
	unsigned short tracks;
	unsigned short blocks_per_track;
	unsigned short sectors_per_block;
	unsigned short bytes_per_sector;
	unsigned char reserved;
	unsigned char major_version;
	unsigned char minor_version;
	unsigned char app_id;
	unsigned char volume_name[13];
	unsigned char volume_num;
	unsigned char last_volume;
	unsigned char last_write_date[11];
	unsigned char last_write_time[6];
	unsigned char reserved2;
	unsigned short free_block;
	unsigned short free_track;
	unsigned short ecc_sectors;
	unsigned char use_ecc;
	unsigned char reserved3[799];
	struct ir_sco_header sco;
	unsigned char bad_map[1024*3];
};
#pragma pack(4)

struct ir_header_segment {
	struct ir_format_record s;
	struct ir_format_record dup[3];
};
typedef struct ir_header_segment ir_header;

#define IR_FIRSTSEG (pheader->s.sco.first)
#define IR_LASTSEG (pheader->s.sco.last)
#define IR_STARTSEG (pheader->s.sco.start)
#define IR_ENDSEG (pheader->s.sco.end)
#define IR_LASTCOUNT (pheader->s.sco.last_count) 

#define IR_SCO_ID 20		/* SCO application ID number */

union ir_old_header_segment {
	unsigned short sector[16][1024/2];
	struct hdr {
		unsigned char reserved [54];
		unsigned short version;
		unsigned short irtype;
		unsigned short sector1;
		unsigned short first; 	/* first block on tape */
		unsigned short last;	/* last block on tape */
		unsigned short start;	/* first block of data */
		unsigned short end;	/* last block of data */
		unsigned short last_count; 	/* bytes in last block */
		unsigned char bitmap_bbt[1024-70];
		struct btt bad_map;
		struct ir_header_fmt_record format;
	} s;
};
typedef union ir_old_header_segment old_header;


#ifdef M_I286
typedef ir_header far *Pir_header;
#else
typedef ir_header *Pir_header;
#endif

#endif	/* _SYS_IR_H */
