#ident	"@(#)gate.h	1.2	90/08/08"
#ifndef _SYS_GATE_H
#define _SYS_GATE_H
#ident "@(#) gate.h 22.1 90/01/15 "
#ident "@(#)gate.h	1.2 89/09/29"
#ident "@(#) gate.h 1.6 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* #ident	"@)#(head.sys:gate.h	1.3" */

/*
 *  Call/Interrupt/Trap Gate table descriptions
 */

struct gate {
	unsigned short g_looff;	/* low word of offset */
	unsigned short g_sel;	/* selector */
	unsigned char g_wcount;	/* word count */
	unsigned char g_type;	/* type of gate and access rights */
	unsigned short g_hioff;	/* high word of the offset */
};
 
/* access rights field for gates */

#define GATE_UACC 0xE0			/* present and dpl = 3 */
#define GATE_KACC 0x80			/* present and dpl = 0 */
#define GATE_386INT 0xE			/* 386 int gate */
#define GATE_386TRP 0xF			/* 386 trap gate */
#define GATE_TSS 0x5			/* TSS gate */

/* make an interrupt gate */
#define MKINTG(rtn) {(short)rtn&0xFFFF, (short)KCS_SEL, (char)0, \
		 (char)(GATE_KACC|GATE_386INT), (short)((rtn&0xFFFF0000)>>16) } 
#define MKKTRPG(rtn) {(short)rtn&0xFFFF, (short)KCS_SEL, (char)0, \
		 (char)(GATE_KACC|GATE_386TRP), (short)((rtn&0xFFFF0000)>>16) } 
#define MKUTRPG(rtn) {(short)rtn&0xFFFF, (short)KCS_SEL, (char)0, \
		 (char)(GATE_UACC|GATE_386TRP), (short)((rtn&0xFFFF0000)>>16) } 

#endif	/* _SYS_GATE_H */
