#ident	"@(#)fstyp.h	1.2	90/08/08"
#ifndef _SYS_FSTYP_H
#define _SYS_FSTYP_H
#ident "@(#) fstyp.h 22.2 90/01/15 "
#ident "@(#)fstyp.h	1.2 89/09/29"
#ident "@(#) fstyp.h 1.9 89/07/27 "
/*
 *	Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 *
 *      Portions Copyright (C) Corollary, Inc., 1986, 1987, 1988, 1989.
 *      All Rights Reserved.
 *      This Module contains Proprietary Information of
 *      Corollary, Inc., and should be treated as Confidential.
 */

/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/


#define NULL_FS	0		/* Null FS type - Invalid */

#define FSTYPSZ		16	/* max size of fs identifier */

/*
 * Opcodes for the sysfs() system call.
 */
#define GETFSIND	1	/* translate fs identifier to fstype index */
#define GETFSTYP	2	/* translate fstype index to fs identifier */
#define GETNFSTYP	3	/* return the number of fstypes */

/* Bit settings for fs_flags */
#define FS_NOICACHE	0x1	/* Don't retain old inodes in in-core cache
				 * after last reference.  Should be off for
				 * the S5 fstyp.
				 */
#define	FS_RECYCLE	0x2	/* Always call FS_IPUT for a recycled inode */
#define	FS_NOTBUFFERED	0x4	/* Fstyp unsuitable for, e.g., RFS caching */

#define	FSBSIZE(ip)	((ip)->i_mntdev)->m_bsize

/* Passed to fs_getinode to indicate intended use of inode */
#define FSG_PIPE	1	/* Pipe */
#define FSG_CLONE	2	/* Use for clone device */

extern	short	pipefstyp;

/*
 * macros and defines for MPX file system switch distribution.
 */

#define FS_PROCESSOR(ip, op, processor)					\
	if ((at_fsinfo[(ip)->i_fstyp] & (op)) == 0) {			\
		PROCtoEPROC(u.u_procp)->ep_flag &= ~EP_ANYP;		\
		if (ATM(processor)) 					\
			qswtch();					\
	}

/*
 * bit-field definitions indicating whether an operation is distributed.
 */
#define DIST_FS_IPUT		0x00001
#define DIST_FS_IREAD		0x00002
#define DIST_FS_IUPDAT		0x00004
#define DIST_FS_READI		0x00008
#define DIST_FS_WRITEI		0x00010
#define DIST_FS_ITRUNC		0x00020
#define DIST_FS_STATF		0x00040
#define DIST_FS_NAMEI		0x00080
#define DIST_FS_OPENI		0x00100
#define DIST_FS_CLOSEI		0x00200
#define DIST_FS_ACCESS		0x00400
#define DIST_FS_GETDENTS	0x00800	
#define DIST_FS_ALLOCMAP	0x01000
#define DIST_FS_FREEMAP		0x02000
#define DIST_FS_READMAP		0x04000
#define DIST_FS_SETATTR		0x08000
#define DIST_FS_NOTIFY		0x10000
#define DIST_FS_FCNTL		0x20000
#define DIST_FS_IOCTL		0x40000
#define DIST_FS_SECURITY	0x80000

#define DIST_FS_ALL		0xFFFFFFFF

/*
 * End of macros and defines for MPX file system switch distribution.
 */

#ifdef FSPTR

#define FS_IPUT(ip) (*(ip)->i_fstypp->fs_iput)(ip)
#define FS_IREAD(ip) (*(ip)->i_fstypp->fs_iread)(ip)
#define FS_IUPDAT(ip, tm1, tm2) (*(ip)->i_fstypp->fs_iupdat)(ip, tm1, tm2)
#define FS_READI(ip) (*(ip)->i_fstypp->fs_readi)(ip)
#define FS_WRITEI(ip) (*(ip)->i_fstypp->fs_writei)(ip)
#define FS_ITRUNC(ip) (*(ip)->i_fstypp->fs_itrunc)(ip)
#define FS_STATF(ip, arg) (*(ip)->i_fstypp->fs_statf)(ip, arg)
#define FS_NAMEI(ip, p, arg) (*(ip)->i_fstypp->fs_namei)(p, arg)
#define FS_OPENI(ip, mode) (*(ip)->i_fstypp->fs_openi)(ip, mode)
#define FS_CLOSEI(ip, f, c, o) (*(ip)->i_fstypp->fs_closei)(ip, f, c, o)
#define FS_ACCESS(ip, mode) (*(ip)->i_fstypp->fs_access)(ip, mode)
#define FS_GETDENTS(ip, bp, bsz) (*(ip)->i_fstypp->fs_getdents)(ip, bp, bsz)
#define FS_ALLOCMAP(ip) (*(ip)->i_fstypp->fs_allocmap)(ip)
#define FS_FREEMAP(ip) (*(ip)->i_fstypp->fs_freemap)(ip)
#define FS_READMAP(ip, off, sz, va, sf) (*(ip)->i_fstypp->fs_readmap)(ip, off, sz, va, sf)
#define FS_SETATTR(ip, mode) (*(ip)->i_fstypp->fs_setattr)(ip, mode)
#define FS_NOTIFY(ip, arg) (*(ip)->i_fstypp->fs_notify)(ip, arg)
#define FS_FCNTL(ip, cmd, arg, flag, offset) (*(ip)->i_fstypp->fs_fcntl)(ip, cmd, arg, flag, offset)
#define FS_IOCTL(ip, cmd, arg, flag) (*(ip)->i_fstypp->fs_ioctl)(ip, cmd, arg, flag)
#define FS_SECURITY(ip, cmd, arg) (*(ip)->i_fstypp->fs_security)(ip, cmd, arg)

#else

#define FS_IPUT(ip) (*fstypsw[(ip)->i_fstyp].fs_iput)(ip)
#define FS_IREAD(ip) (*fstypsw[(ip)->i_fstyp].fs_iread)(ip)
#define FS_IUPDAT(ip, tm1, tm2) (*fstypsw[(ip)->i_fstyp].fs_iupdat)(ip, tm1, tm2)
#define FS_READI(ip) (*fstypsw[(ip)->i_fstyp].fs_readi)(ip)
#define FS_WRITEI(ip) (*fstypsw[(ip)->i_fstyp].fs_writei)(ip)
#define FS_ITRUNC(ip) (*fstypsw[(ip)->i_fstyp].fs_itrunc)(ip)
#define FS_STATF(ip, arg) (*fstypsw[(ip)->i_fstyp].fs_statf)(ip, arg)
#define FS_NAMEI(ip, p, arg) (*fstypsw[(ip)->i_fstyp].fs_namei)(p, arg)
#define FS_OPENI(ip, mode) (*fstypsw[(ip)->i_fstyp].fs_openi)(ip, mode)
#define FS_CLOSEI(ip, f, c, o) (*fstypsw[(ip)->i_fstyp].fs_closei)(ip, f, c, o)
#define FS_ACCESS(ip, mode) (*fstypsw[(ip)->i_fstyp].fs_access)(ip, mode)
#define FS_GETDENTS(ip, bp, bsz) (*fstypsw[(ip)->i_fstyp].fs_getdents)(ip, bp, bsz)
#define FS_ALLOCMAP(ip) (*fstypsw[(ip)->i_fstyp].fs_allocmap)(ip)
#define FS_FREEMAP(ip) (*fstypsw[(ip)->i_fstyp].fs_freemap)(ip)
#define FS_READMAP(ip, off, sz, va, sf) (*fstypsw[(ip)->i_fstyp].fs_readmap)(ip, off, sz, va, sf)
#define FS_SETATTR(ip, mode) (*fstypsw[(ip)->i_fstyp].fs_setattr)(ip, mode)
#define FS_NOTIFY(ip, arg) (*fstypsw[(ip)->i_fstyp].fs_notify)(ip, arg)
#define FS_FCNTL(ip, cmd, arg, flag, offset) (*fstypsw[(ip)->i_fstyp].fs_fcntl)(ip, cmd, arg, flag, offset)
#define FS_IOCTL(ip, cmd, arg, flag) (*fstypsw[(ip)->i_fstyp].fs_ioctl)(ip, cmd, arg, flag)
#define FS_SECURITY(ip, cmd, arg) (*fstypsw[(ip)->i_fstyp].fs_security)(ip, cmd, arg)

#endif

#endif	/* _SYS_FSTYP_H */
