#ident	"@(#)dosmacros.h	1.2	90/08/08"
#ifndef _SYS_FS_DOSMACROS_H
#define _SYS_FS_DOSMACROS_H
#ident	"@(#) dosmacros.h 22.1 90/01/15 "
#ident "@(#)dosmacros.h	1.2 89/09/29"
#ident	"@(#) dosmacros.h 1.4 89/07/27 "

/*	Copyright (C) The Santa Cruz Operation, 1988, 1989.	*/

/*	This Module contains Proprietary Information of		*/
/*	The Santa Cruz Operation and should be treated		*/
/*	as Confidential.					*/

						/* BEGIN SCO_FS */


#define	TRUE	1
#define	FALSE	0

#define FsLRG(bsize)		((bsize)==1024)
#define FsBSIZE(bsize)		(bsize)
#define FsBSHIFT(bsize)		(FsLRG(bsize) ? 10 : 9)
#define FsBMASK(bsize)		(FsLRG(bsize) ? 01777 : 0777)
#define FsITOD(bsize, x)	(daddr_t)(((unsigned long)(x)) >> FsBSHIFT(bsize))
#define FsITOO(bsize, x)	(ushort)(((unsigned long)(x)) & FsBMASK(bsize))
#define FsLTOP(bsize, b)	(FsLRG(bsize) ? ((b)<<1) : (b))
#define FsPTOL(bsize, b)	(FsLRG(bsize) ? ((b)>>1) : (b))

#define	FsCSIZE(mp)		(((struct dosfilsys *)mp->m_bufp)->s_csize)
#define	FsCMAX(mp)		(((struct dosfilsys *)mp->m_bufp)->s_clustmax)
#define	FsFATMAX(fp)		(fp->s_clustmax)
#define	FsGETBSIZE(fp)		(DOS_NBPS)

/*
 * macros for accessing binary data in the DOS filesystem
 */
#if	i386 || i286
#define	getbyte(p)	(*(unchar *)(p))
#define	getword(p)	(*(ushort *)(p))
#define	getdword(p)	(*(ulong *)(p))
#define	putbyte(p, v)	(*(unchar *)(p) = (unchar)(v))
#define	putword(p, v)	(*(ushort *)(p) = (ushort)(v))
#define	putdword(p, v)	(*(ulong *)(p) = (ulong)(v))
#else
ERROR ****))))	
#endif

extern time_t	dosgettime();
extern unsigned	dosnextcluster();
						/* END SCO_FS */

#endif /* _SYS_FS_DOSMACROS_H */
