#ident	"@(#)file.h	1.2	90/08/08"
#ifndef _SYS_FILE_H
#define _SYS_FILE_H
#ident "@(#) file.h 22.7 90/03/19 "
#ident "@(#)file.h	1.5 90/06/05"
#ident "@(#) file.h 22.1 89/11/27 "
/*
 *	Portions Copyright 1983-1990 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 *
 *      Portions Copyright (C) Corollary, Inc., 1986, 1987, 1988, 1989.
 *      All Rights Reserved.
 *      This Module contains Proprietary Information of
 *      Corollary, Inc., and should be treated as Confidential.
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */

/*
 * One file structure is allocated for each open/creat/pipe call.
 * Main use is to hold the read/write pointer associated with
 * each open file.
 */

typedef struct file
{
	ushort	f_flag;						/* S000 */
	cnt_t	f_count;		/* reference count */
	union {
		struct inode *f_uinode;	/* pointer to inode structure */
		struct file  *f_unext;	/* pointer to next entry in freelist */
	} f_up;
	union {
		off_t	f_off;
		struct	file *f_slnk;	/* XENIX semaphore queue */
	} f_un;
} file_t;

#define f_inode		f_up.f_uinode
#define f_next		f_up.f_unext
#define f_offset	f_un.f_off	/* read/write character pointer */
#ifdef DYNAMIC
extern struct file *file;	/* The file table itself */
#else

#endif

extern struct file file[];	/* The file table itself */
extern struct file *ffreelist;	/* Head of freelist pool */

/* flags */

#define	FOPEN	0xffffffff
#define	FREAD	0x01
#define	FWRITE	0x02
#define	FNDELAY	0x04
#define	FAPPEND	0x08
#define FSYNC	0x10
#define	FNONBLOCK	0x80
#define FRCACH  0x20		/* Used for file and record locking cache*/
#define FSTOPIO	0x40		/* prevent further I/O */	/* SCO_C2TCB */
#define	FMASK	0xff		/* FMASK should be disjoint from FNET */
#define FNET	0x100		/* needed by 3bnet */

/* open only modes */

#define	FCREAT	0x100
#define	FTRUNC	0x200
#define	FEXCL	0x400
#define	FNOCTTY	0x800
#endif	/* _SYS_FILE_H */
