#ident	"@(#)fdisk.h	1.2	90/08/08"
#ifndef _SYS_FDISK_H
#define _SYS_FDISK_H
#ident "@(#) fdisk.h 22.2 90/01/15 "
#ident "@(#)fdisk.h	1.2 89/09/29"
#ident "@(#) fdisk.h 1.6 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* fdisk.h
 * This file defines the structure of physical disk sector 0 for use on
 * AT386 systems.  The format of this sector is constrained by the ROM
 * BIOS and MS-DOS conventions.
 * Note that this block does not define the partitions used by the unix
 * driver.  The unix partitions are obtained from the VTOC.
 */

/* #ident	"@)#(head.sys:fdisk.h	1.3.1.1" */

#define BOOTSZ		446	/* size of boot code in master boot block */
#define FD_NUMPART	4	/* number of 'partitions' in fdisk table */
#define MBB_MAGIC	0xAA55	/* magic number for mboot.signature */
#define DEFAULT_INTLV	4	/* default interleave for testing tracks */
#define MINPSIZE	4	/* minimum number of cylinders in a partition */
#define TSTPAT		0xE5	/* test pattern for verifying disk */

/*
 * structure to hold the fdisk partition table
 */
struct ipart {
	unsigned char bootid;	/* bootable or not */
	unsigned char beghead;	/* beginning head, sector, cylinder */
	unsigned char begsect;	/* begcyl is a 10-bit number. High 2 bits */
	unsigned char begcyl;	/*     are in begsect. */
	unsigned char systid;	/* OS type */
	unsigned char endhead;	/* ending head, sector, cylinder */
	unsigned char endsect;	/* endcyl is a 10-bit number.  High 2 bits */
	unsigned char endcyl;	/*     are in endsect. */
	long    relsect;	/* first sector relative to start of disk */
	long    numsect;	/* number of sectors in partition */
};
/*
 * Values for bootid.
 */
#define NOTACTIVE	0
#define ACTIVE		128
/*
 * Values for systid.
 */
#define DOSOS12		1	/* DOS partition, 12-bit FAT */
#define PCIXOS		2	/* PC/IX partition */
#define DOSDATA		86	/* DOS data partition */
#define DOSOS16		4	/* DOS partition, 16-bit FAT */
#define EXTDOS		5	/* EXT-DOS partition */
#define OTHEROS		98	/* part. type for appl. (DB?) needs raw partition */
				/* ID was 0 but conflicted with DOS 3.3 fdisk    */
#define UNIXOS		99	/* UNIX V.x partition */
#define UNUSED		100	/* unassigned partition */
#define MAXDOS		65535L	/* max size (sectors) for DOS partition */
/*
 * structure to hold master boot block in physical sector 0 of the disk.
 * Note that partitions stuff can't be directly included in the structure
 * because of lameo '386 compiler alignment design.
 */

struct  mboot {     /* master boot block */
	char    bootinst[BOOTSZ];
	char    parts[FD_NUMPART * sizeof(struct ipart)];
	ushort   signature;
};


#endif	/* _SYS_FDISK_H */
