#ident "@(#)fcntl.h	1.4 91/04/01"
#ifndef	_SYS_FCNTL_H
#define	_SYS_FCNTL_H

/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1990 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */
/*
 *      Portions Copyright (C) The Santa Cruz Operation, 1985 - 1990
 *      This Module contains Proprietary Information of the Santa
 *      Cruz Operation, and should be treated as confidential.
 */


/* #ident	"@)#(head.sys:fcntl.h	1.3.1.3" */

#include <sys/types.h>

#ifdef	M_XOUT
#	include	"lockcmn.h"
#endif	/* M_XOUT */
/* Flag values accessible to open(2) and fcntl(2) */
/*  (The first three can only be set by open) */
#define	O_RDONLY	0000
#define	O_WRONLY	0001
#define	O_RDWR		0002
#define O_ACCMODE	0003	/* Mask for O_RDONLY | O_WRONLY | O_RDWR */
#define	O_NDELAY	0004	/* Non-blocking I/O */
#define	O_NONBLOCK	0200	/* Non-blocking I/0, but different effect */
#define	O_APPEND	0010	/* append (writes guaranteed at the end) */
#if	defined( M_XOUT )
#	if	defined( M_I386 )
#		define	O_SYNCW	0020
#	else
#		define	O_SYNCW	00100
#	endif	/* 386 or 286? */
#	define	O_SYNC	O_SYNCW
#else
#	define O_SYNC	 0020	/* synchronous write option */
#endif	/* X.out ? */

/* Flag values accessible only to open(2) */
#define	O_CREAT	00400	/* open with file create (uses third open arg)*/
#define	O_TRUNC	01000	/* open with truncation */
#define	O_EXCL	02000	/* exclusive open */
#define	O_NOCTTY 04000	/* No controlling tty POSIX */

/* fcntl(2) requests */
#define	F_DUPFD		0	/* Duplicate fildes */
#define	F_GETFD		1	/* Get fildes flags */
#define	F_SETFD		2	/* Set fildes flags */
#define	F_GETFL		3	/* Get file flags */
#define	F_SETFL		4	/* Set file flags */
#define	F_GETLK		5	/* Get file lock */
#define	F_SETLK		6	/* Set file lock */
#define	F_SETLKW	7	/* Set file lock and wait */
#define	F_CHKFL		8	/* reserved */
#define	F_ALLOCSP	10	/* reserved */
#define	F_FREESP	11	/* reserved */
#define F_CHSIZE	0x6000 	/* XENIX chsize() system call */	
#define F_RDCHK		0x6001	/* XENIX rdchk() system call */

/*
 * Argument value for F_SETFD
 */
#define FD_CLOEXEC	0x01

/*
 * Fcntl(2) requests made from the XENIX locking(S) system call.  These fcntl() 
 * requests are made only from the kernel.
 *
 * N.B.  The high nibble of the high byte is F_SETLK or F_SETLKW, and the low
 *       nibble of the high byte is F_UNLCK, F_WRLCK, or F_RDLCK.  However,
 *	 no code actually relies on this.  
 */ 

#define F_LK_UNLCK	0x6300	/* locking() LK_UNLCK request */
#define F_LK_LOCK	0x7200	/* locking() LK_LOCK request */
#define F_LK_NBLCK	0x6200	/* locking() LK_NBLCK request */
#define F_LK_RLCK	0x7100	/* locking() LK_RLCK request */
#define F_LK_NBRLCK	0x6100	/* locking() LK_NBRLCK request */

#define LK_CMDTYPE(x)	((x >> 12) & 0x7) /* get high nibble of high byte */
#define LK_LCKTYPE(x)	((x >> 8) & 0x7)  /* get low nibble of high byte */


/* file segment locking set data type - information passed to system by user */
struct flock {
	short	l_type;
	short	l_whence;
	long	l_start;
	long	l_len;		/* len = 0 means until end of file */
#if	defined( M_I386 )
        short   l_sysid;
        pid_t  	l_pid;
#else
        short   l_pid;
        short   l_sysid;
#endif
};

/* file segment locking types */

#if	defined( M_XOUT )
#	define	F_RDLCK	CMN_RDLCK
#	define	F_WRLCK	CMN_WRLCK
#	define	F_UNLCK	CMN_UNLCK
#	define	CF_RDLCK	1
#	define	CF_WRLCK	2
#	define	CF_UNLCK	3
#else
#	define	F_RDLCK	01	/* Read lock */
#	define	F_WRLCK	02	/* Write lock */
#	define	F_UNLCK	03	/* Remove lock(s) */
#endif

#endif	/* _SYS_FCNTL_H */
