#ident	"@(#)dma.h	1.4	90/08/08"
#ifndef _SYS_DMA_H
#define _SYS_DMA_H
#ident	"@(#) dma.h 22.2 90/01/15 "
#ident "@(#)dma.h	1.5 90/01/17"
#ident "@(#) dma.h 1.6 89/06/17 "
/*
 *   Portions Copyright 1989 Altos Computer Systems
 *		      All Rights Reserved
 */
/*
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */

/* #ident	"@(#)head.sys:dma.h	1.4" */

/*
 * Defines for PC AT DMA controllers.
 * The PC AT has two intel 8237A-5 dma controllers with page registers
 * for each channel, allowing access to the entire 16M address space.
 */

#define	DMACH0PG	0x87	/* port address for dma chan. 0 page reg. */
#define	DMACH1PG	0x83	/* port address for dma chan. 1 page reg. */
#define	DMACH2PG	0x81	/* port address for dma chan. 2 page reg. */
#define	DMACH3PG	0x82	/* port address for dma chan. 3 page reg. */
#define	DMACH5PG	0x8b	/* port address for dma chan. 5 page reg. */
#define	DMACH6PG	0x89	/* port address for dma chan. 6 page reg. */
#define	DMACH7PG	0x8a	/* port address for dma chan. 7 page reg. */

/*
 * I/O port addresses for controller 1 programming.
 */
#define	DMA1BCA0	0x00	/* chan. 0 base and current address */
#define	DMA1BCWC0	0x01	/* chan. 0 base and current word count */
#define	DMA1BCA1	0x02	/* chan. 1 base and current address */
#define	DMA1BCWC1	0x03	/* chan. 1 base and current word count */
#define	DMA1BCA2	0x04	/* chan. 2 base and current address */
#define	DMA1BCWC2	0x05	/* chan. 2 base and current word count */
#define	DMA1BCA3	0x06	/* chan. 3 base and current address */
#define	DMA1BCWC3	0x07	/* chan. 3 base and current word count */
#define DMA1RSWWCR	0x08	/* read status reg/write command reg */
#define	DMA1WRR		0x09	/* write request register */
#define	DMA1WSMR	0x0a	/* write single mask register bit */
#define	DMA1WMR		0x0b	/* write mode register */
#define	DMA1CBPFF	0x0c	/* clear byte pointer flip flop */
#define	DMA1RTRWMC	0x0d	/* read temp reg/write master clear */
#define	DMA1CMR		0x0e	/* clear mask register */
#define	DMA1WAMRB	0x0f	/* write all mask register bits */

/*
 * I/O port addresses for controller 2 programming.
 */
#define	DMA2BCA0	0xc0	/* chan. 0 base and current address */
#define	DMA2BCWC0	0xc2	/* chan. 0 base and current word count */
#define	DMA2BCA1	0xc4	/* chan. 1 base and current address */
#define	DMA2BCWC1	0xc6	/* chan. 1 base and current word count */
#define	DMA2BCA2	0xc8	/* chan. 2 base and current address */
#define	DMA2BCWC2	0xca	/* chan. 2 base and current word count */
#define	DMA2BCA3	0xcc	/* chan. 3 base and current address */
#define	DMA2BCWC3	0xce	/* chan. 3 base and current word count */
#define DMA2RSWWCR	0xd0	/* read status reg/write command reg */
#define	DMA2WRR		0xd2	/* write request register */
#define	DMA2WSMR	0xd4	/* write single mask register bit */
#define	DMA2WMR		0xd6	/* write mode register */
#define	DMA2CBPFF	0xd8	/* clear byte pointer flip flop */
#define	DMA2RTRWMC	0xda	/* read temp reg/write master clear */
#define	DMA2CMR		0xdc	/* clear mask register */
#define	DMA2WAMRB	0xde	/* write all mask register bits */

/*
 * defines for the Intel ISP chip (in addition to the standard defs)
 * Note: all channels can be 8, 16, or 32 bit using the extended commands
 */

/* DMA High page registers (last 8 bits of 32 bits) */
#define	DMA_0HADR	0x487	/* Channel 0 High address reg */
#define	DMA_1HADR	0x483	/* Channel 1 High address reg */
#define	DMA_2HADR	0x481	/* Channel 2 High address reg */
#define	DMA_3HADR	0x482	/* Channel 3 High address reg */
#define	DMA_5HADR	0x48b	/* Channel 5 High address reg */
#define	DMA_6HADR	0x489	/* Channel 6 High address reg */
#define	DMA_7HADR	0x48a	/* Channel 7 High address reg */

/* Stop register bits */

/* Base / Current count regs */

/* DMA Chaining mode control regs */
#define	CTL1_CHAIN	0x40a	/* chan 0 - 3 set chain mode register */
#define	CTL2_CHAIN	0x4d4	/* chan 5 - 7 set chain mode register */

/* Extended Write Mode registers */
#define	CTL1_XMODE	0x40b	/* chan 0 - 3 extended write mode reg */
#define	CTL2_XMODE	0x4d6	/* chan 5 - 7 extended write mode reg */

/* Extended Write mode bit fields */
#define	DMA_XCOMPAT	0x00	/* 8237 compatable mode */
#define	DMA_X16IOWORD	0x04	/* 16 bit I/O count by words (address shifted) */
#define	DMA_X32IOBYTE	0x08	/* 32 bit I/O count by bytes */
#define	DMA_X16IOBYTE	0x0c	/* 16 bit I/O count by bytes */
#define	DMA_XATIMING	0x10	/* Type "A" timing */
#define	DMA_XBTIMING	0x20	/* Type "B" timing */
#define	DMA_XBURST	0x30	/* Burst timing */

/* Misc DMA regs */

/* end ISP specific */

/*
 * defines for XENIX compatibility
 */

/*
 * Intel 8237 DMA Controller.
 */

/*
 * DMA I/O Port Assignments.
 */
/* 8 bit channel specific registers on controller 1 */
#define DMA_0ADR 	0x00	/* Channel  address register */
#define DMA_0WCNT 	0x01	/* Channel  word count */
#define DMA_1ADR 	0x02	/* Channel  address register */
#define DMA_1WCNT 	0x03	/* Channel  word count */
#define DMA_2ADR 	0x04	/* Channel  address register */
#define DMA_2WCNT 	0x05	/* Channel  word count */
#define DMA_3ADR 	0x06	/* Channel  address register */
#define DMA_3WCNT 	0x07	/* Channel  word count */

/* 16 bit channel specific registers on controller 1.
 * Chip A0 connected to bus A1, etc. so even address 
 * increments generated by this controller.  Hence, 
 * 16 bit dma, and only even i/o addresses. Channel 4
 * used to cascade controllers.
 */
#define DMA_5ADR 	0xC4	/* Channel  address register */
#define DMA_5WCNT 	0xC6	/* Channel  word count */
#define DMA_6ADR 	0xC8	/* Channel  address register */
#define DMA_6WCNT 	0xCA	/* Channel  word count */
#define DMA_7ADR 	0xCC	/* Channel  address register */
#define DMA_7WCNT 	0xCE	/* Channel  word count */

/* DMA controller 1, 8 bit channels */
#define CTL1_CMD	0x08	/* Command reg */
#define CTL1_STAT	0x08	/* Status reg */
#define CTL1_RES_MSK    0x0A	/* Mask set/reset register */
#define CTL1_MODE	0x0B	/* Mode reg */
#define CTL1_CLFF	0x0C	/* Clear byte pointer first/last flip-flop */

#define EXTND_REG	0x18	/* Extended Function Register */
#define EXTND_EXC	0x1A	/* Extended Function Execute  */

#define ST506BIT	0x10	/* is this an st506 on channel 3 ?? */
#define CHANUMASK	0x0F	/* mask to give channel number only */
#define EXTND_MODE_8	0x20	/* 8-bit extended mode (PS/2s only) */
#define EXTND_MODE_16	0x10	/* 16-bit extended mode (PS/2s only) */
#define EXTND_MODE	0x30	/* mask for either */

/* DMA controller 2, 16 bit channels */
#define CTL2_CMD	0xD0	/* Command reg */
#define CTL2_STAT	0xD0	/* Status reg */
#define CTL2_RES_MSK    0xD4	/* Mask set/reset register */
#define CTL2_MODE	0xD6	/* Mode reg */
#define CTL2_CLFF	0xD8	/* Clear byte pointer first/last flip-flop */
#define DMA_ROT_PRI	0x10	/* Set rotating priority in the command reg */


/* 8 bit channels */
#define DMA_0XADR	0x87	/* Channel 0 address extension reg */
#define DMA_1XADR 	0x83	/* Channel 1 address extension reg */
#define DMA_2XADR 	0x81	/* Channel 2 address extension reg */
#define DMA_3XADR 	0x82	/* Channel 3 address extension reg */

/* 16 bit channels */
#define DMA_5XADR 	0x8B	/* Channel 5 address extension reg */
#define DMA_6XADR 	0x89	/* Channel 6 address extension reg */
#define DMA_7XADR 	0x8A	/* Channel 7 address extension reg */


#define DMA_MSK		0x0A	/* Mask, enable disk, disable others */
#define DMA_CLEAR	0x1A	/* Master clear */
#define IOCR		0x56	/* IO controller */

/*
 * DMA Channels. d_chan field of dmareq.
 */

#define NCHANS		8

/* 8 bit channels */
#define DMA_CH0		0	/* Channel 0 */
#define DMA_CH1		1	/* Channel 1 */
#define DMA_CH2		2	/* Channel 2 */
#define DMA_CH3		3	/* Channel 3 */
/* 16 bit channels */
#define DMA_CH5		5	/* Channel 5 */
#define DMA_CH6		6	/* Channel 6 */
#define DMA_CH7		7	/* Channel 7 */

/*
 * DMA Masks.
 */
#define DMA_SETMSK	4	/* Set mask bit */
#define DMA_CLRMSK	0	/* Clear mask bit */
#define EXTND_SETMSK	0x90	/* Set (extended mode) mask bit */
#define EXTND_CLRMSK	0xA0	/* Clear (extended mode) mask bit */

/*
 * DMA Commands. d_mode field of dmareq.
 */
/* from memory to device */
#define DMA_Wrmode	0x48	/* single, read, increment, no auto-init */
/* from device to memory */
#define DMA_Rdmode	0x44	/* single, write, increment, no auto-init */
#define DMA_Casmode	0xc0	/* Cascade mode for ISA bus masters */
#define DMA_Nomode	0x0C	/* illegal mode */

#define EXTND_ADDR	0x20	/* Clear byte pointer (extended mode) */
#define EXTND_WCOUNT	0x40	/* Write to transfer count */
#define EXTND_RCOUNT	0x50	/* Read transfer count */
#define EXTND_WMODE	0x45	/* 16 Bit write to memory*/
#define EXTND_RMODE	0x4D	/* 16 Bit read to memory */
#define EXTND_SETMODE	0x70	/* Write to the mode register */

#define DMAPRI	PRIBIO

/* dma_alloc modes */
#define DMA_BLOCK	0	/* blocking task time allocation */
#define DMA_NBLOCK	1	/* non-blocking task time allocation */

struct dmareq
{   struct dmareq	*d_nxt;		/* reserved */
    unsigned short	 d_chan;	/* specifies channel */
    unsigned short	 d_mode;	/* direction of transfer */
    paddr_t		 d_addr;	/* physical src or dst */
    long		 d_cnt;		/* byte or word (16 bit chan) count */
    int		       (*d_proc)();	/* address of dma routine */
    char		*d_params;	/* driver defineable param block */
};


#endif	/* _SYS_DMA_H */
