#ident	"@(#)cram.h	1.2	90/08/08"
#ifndef _SYS_CRAM_H
#define _SYS_CRAM_H
#ident "@(#) cram.h 22.2 90/04/25 "
#ident "@(#)cram.h	1.3 89/11/30"
#ident "@(#) cram.h 1.7 89/07/27 "
/*
 *	      UNIX is a registered trademark of AT&T
 *		Portions Copyright 1976-1989 AT&T
 *	Portions Copyright 1980-1989 Microsoft Corporation
 *   Portions Copyright 1983-1990 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 *	Copyright (C) The Santa Cruz Operation, 1988, 1989, 1990.
 *	This Module contains Proprietary Information of
 *
 *	The Santa Cruz Operation and should be treated as Confidential.
 */

/*
 * Defines for accessing the PC AT CMOS ram.
 */

/* #ident	"@)#(head.sys:cram.h	1.4" */

#define	CMOS_ADDR	0x70	/* I/O port address for CMOS ram address */
#define	CMOS_DATA	0x71	/* I/O port address for CMOS ram data */

#define	DSB		0x0e	/* Diagnostic status byte ram address */
#define	SSB		0x0f	/* Shutdown status byte ram address */
#define DDTB		0x10	/* Diskette drive type byte ram address */
#define	FDTB		0x12	/* Fixed disk type byte ram address */
#define	EB		0x14	/* Equipment byte ram address */
#define	BMLOW		0x15	/* Base mem size low byte ram address */
#define	BMHIGH		0x16	/* Base mem size high byte ram address */
#define	EMLOW		0x17	/* Expansion mem size low byte ram address */
#define	EMHIGH		0x18	/* Expansion mem size high byte ram address */
#define	DCEB		0x19	/* Drive C Extended byte ram address */
#define	IREV		0x2a	/* i486 revision identifier */
#define	DDEB		0x1a	/* Drive D Extended byte ram address */
#define	CKSUMLOW	0x2e	/* Checksum low byte ram address */
#define	CKSUMHIGH	0x2f	/* Checksum high byte ram address */
#define	EMLOW2		0x30	/* Expansion mem size low byte ram address */
#define	EMHIGH2		0x31	/* Expansion mem size high byte ram address */
#define	DCB		0x32	/* Date century byte ram address */
#define	IF		0x33	/* Information flag ram address */

/*
 * ioctls for accessing CMOS ram.
 */
#define CMOSIOC	('C' << 8)

#define	CMOSREAD	(CMOSIOC | 0x01)
#define	CMOSWRITE	(CMOSIOC | 0x02)

extern unsigned char	CMOSread();

/*
 * definitions for Micro Channel Architecture POS register
 * support: for the cdb/Driver.o and the /etc/slot utility
 */
#define	MCAPOS_MINOR	0x02	/* /dev/mcapos minor number */

#define	CARD_FEEDBACK	0x91	/* card select feedback register */
#define	ADSLOT_SELECT	0x96	/* adapter enable/setup regsiter */
#define	POSREG_BASE	0x100	/* POS register base */

#define NADSLOT		8	/* adapter slots available */
#define NPOSREG		8	/* max number of POS registers per slot */

#define NO_AID		(unsigned short)(0xffff)
#define MCA_AID(p)	*((unsigned short *)(p))

/*
 * The following table provides info on all adapters.
 * Other drivers which access it at init time must
 * call cdbinit() first to ensure it is initialized.
 * This table can be read from /dev/mcapos.
 */
extern	unsigned char	mcapos[NADSLOT][NPOSREG];

/*
 * defines for XENIX compatibility
 */

/* Ports for interacting with chip at */

#define CMOSADDR	0x70 	/* Use to select RAM address */
#define CMOSDATA	0x71	/* R/W data */

/* Number of cmos bytes */

#define CMOSSIZE	0x40	/* 64 addressable bytes in chip */

/* Addresses of interest */

#define CMOSDIAG	0x0e	/* Diagnostic Status */
#define CMOSFDT		0x10	/* Floppy Disk Type */
#define CMOSHDT		0x12	/* Hard Disk Type; bits 7-4 are 1st drive */
#define CMOSKBD		0x13	/* Keyboard options */
#define CMOSEQP		0x14	/* Diskette, Video, and CoProcessor info */
#define CMOSADF		0x2d	/* Additional flags - Compaq VDU info */
#define CMOSSID		0x24	/* System ID Byte  - Compaq */
#define CMOSSOP		0x25	/* System Op Byte  - Compaq */
#define CMOSSYI		0x26	/* System Information - Compaq info */

/* Shifts of interest */

#define VID_SHFT	4	/* Shift display type bits into 0-3 */

/* masks of interest */
#define CMPQVDU		0x04	/* Compaq VDU bit */
#define CMPQDMM		0x01	/* Compaq Dual Mode Monitor bit */
#define CMPQDIAG	0x03	/* Compaq Diag port test in CMOSSOP */
#define CMPQDMEM	0x00	/* Compaq mem-mapped Diag register */
#define CMPQDIO		0x01	/* Compaq I/O-mapped Diag register */
#define CMPQSRV		0x02	/* Compaq "server mode" if true in CMOSKBD */

#endif	/* _SYS_CRAM_H */
