#ident	"@(#)console.h	1.2	90/08/08"
#ifndef _SYS_CONSOLE_H
#define _SYS_CONSOLE_H
#ident "@(#) console.h 22.2 90/01/15 "
#ident "@(#)console.h	1.5 90/03/29"
#ident "@(#) console.h 1.11 89/07/31 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1984-1989.
 *	Copyright (C) Microsoft Corporation, 1984, 1985, 1986, 1987.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 */

/*
 *	User level include file for: 
 *	PC Console keyboard related defines and variables.
 */

#define NUM_ASCII	256	/* Number of ascii characters */

#define GIO_COLOR  ('c'<<8)	/* Ioctl for present color card status */
#define GIO_ATTR   ('a'<<8)	/* Ioctl for present char mode */

#define MIOC	('k' << 8)
#define GIO_SCRNMAP	(MIOC | 2)	/* Get screen output map table */
#define PIO_SCRNMAP	(MIOC | 3)	/* Put screen output map table */

typedef unsigned char scrnmap_t[NUM_ASCII];

/* PC/AT Cga adapter control */
#define	CGAIOC	('C' << 8)	
#define	CGAMODE (CGAIOC | 1)		/* change cga mode */
#define CGAIO	(CGAIOC | 2)		/* do inb/outb on cga port */
#define CGA_GET (CGAIOC | 3)		/* get cga mode setting */

#define INTERNAL_VID	(CGAIOC|72)	/* internal plasma monitor	*/
#define EXTERNAL_VID	(CGAIOC|73)	/* external plasma monitor	*/

/* PC/AT Pga adapter control */
#define PGAIOC	('P' << 8)
#define PGAMODE (PGAIOC | 1)		/* change pga mode */
#define PGAIO	(PGAIOC | 2)		/* do inb/outb on pga port */
#define PGA_GET (PGAIOC | 3)		/* get pga mode setting */

/* PC/AT Ega adapter control */
#define EGAIOC	('E' << 8)
#define EGAMODE (EGAIOC | 1)		/* change ega mode */
#define EGAIO	(EGAIOC | 2)		/* do inb/outb on ega port */
#define EGA_GET (EGAIOC | 3)		/* get ega mode setting */
#define EGA_IOPRIVL (EGAIOC | 4)	/* get in/out privilege for ega ports */

/* PC/AT Vga adapter control */
#define VGAIOC	('E' << 8)
#define VGAMODE (VGAIOC | 65)		/* change vga mode */
#define VGAIO	(VGAIOC | 66)		/* do inb/outb on vga port */
#define VGA_GET (VGAIOC | 67)		/* get vga mode setting */
#define VGA_IOPRIVL (VGAIOC | 68)	/* get in/out privilege for vga ports */

/* PC/AT Mca adapter control */
#define MCAIOC	('M' << 8)
#define MCAMODE	(MCAIOC | 1)		/* change mca mode */
#define MCAIO	(MCAIOC | 2)		/* do inb/outb on mca port */
#define MCA_GET (MCAIOC | 3)		/* get mca mode setting */

/* PC/AT Extended Adapter Support */
#define	C_IOC	('X' << 8)
#define	MAP_CLASS (C_IOC | 1)	/* get memorymap and IO privl for */
				/* video "class" */

/* Hercules support */
#define SW_HGC_P0  (MODESWITCH | M_HGC_P0)
#define SW_HGC_P1  (MODESWITCH | M_HGC_P1)

/* Common PC/AT adapter control */

#include <sys/comcrt.h>

/* Defines for console-switching ioctl -- MONO, CGA, PGA, and EGA */
/* definitions are in comcrt.h  				  */	
#define SWAPCONS ('s' << 8)
#define SWAPMONO (SWAPCONS | MONO)
#define SWAPCGA  (SWAPCONS | CGA)
#define SWAPPGA  (SWAPCONS | PGA)
#define SWAPEGA  (SWAPCONS | EGA)
#define SWAPVGA  (SWAPCONS | VGA)

/* defines for mode-switching ioctl -- modes are defined in comcrt.h */
#define MODESWITCH ('S' << 8)
#define SW_B40x25  (MODESWITCH | M_B40x25)
#define SW_C40x25  (MODESWITCH | M_C40x25)
#define SW_B80x25  (MODESWITCH | M_B80x25)
#define SW_C80x25  (MODESWITCH | M_C80x25)
#define SW_BG320   (MODESWITCH | M_BG320)
#define SW_CG320   (MODESWITCH | M_CG320)
#define SW_BG640   (MODESWITCH | M_BG640)
#define SW_EGAMONO80x25 (MODESWITCH | M_EGAMONO80x25)
#define SW_CG320_D    (MODESWITCH | M_CG320_D)
#define SW_CG640_E    (MODESWITCH | M_CG640_E)
#define SW_EGAMONOAPA (MODESWITCH | M_EGAMONOAPA)
#define SW_CG640x350  (MODESWITCH | M_CG640x350)
#define SW_ENH_MONOAPA2 (MODESWITCH | M_ENHMONOAPA2)
#define SW_ENH_CG640  (MODESWITCH | M_ENH_CG640)
#define SW_ENHB40x25  (MODESWITCH | M_ENH_B40x25)
#define SW_ENHC40x25  (MODESWITCH | M_ENH_C40x25)
#define SW_ENHB80x25  (MODESWITCH | M_ENH_B80x25)
#define SW_ENHC80x25  (MODESWITCH | M_ENH_C80x25)
#define SW_ENHB80x43  (MODESWITCH | M_ENH_B80x43)
#define SW_ENHC80x43  (MODESWITCH | M_ENH_C80x43)
#define SW_MCAMODE    (MODESWITCH | M_MCA_MODE)
#define SW_VGA40x25	(MODESWITCH | M_VGA_40x25)
#define SW_VGA80x25	(MODESWITCH | M_VGA_80x25)
#define SW_VGAM80x25	(MODESWITCH | M_VGA_M80x25)
#define SW_VGA11	(MODESWITCH | M_VGA11)
#define SW_VGA12	(MODESWITCH | M_VGA12)
#define SW_VGA13	(MODESWITCH | M_VGA13)

/* defines for display memory mapping ioctl (see consioctl in console.c) */
#define MAPADAPTER ('m' << 8)
#define MAPCONS (MAPADAPTER)  
#define MAPMONO (MAPADAPTER | MONO)
#define MAPCGA  (MAPADAPTER | CGA) 
#define MAPPGA  (MAPADAPTER | PGA)
#define MAPEGA  (MAPADAPTER | EGA)
#define MAPVGA  (MAPADAPTER | VGA)

/* defines for ibm keyboard ioctls (see consioctl in console.c) */
#define FKEYIOC   ('k' << 8)
#define GETFKEY   (FKEYIOC)
#define SETFKEY   (FKEYIOC | 1)
#define TIOCKBON  (TIOC|8)
#define TIOCKBOF  (TIOC|9)
#define KBENABLED (TIOC|10)

#define SW_MCAMODE    (MODESWITCH | M_MCA_MODE)

#if defined(M_I386) || defined(i386)
#pragma pack(2)
#endif

/* structure used for SETFKEY and GETFKEY ioctls */
struct fkeyarg {	
	unsigned short	keynum;
	char	 	keydef[MAXFK];
	char		flen;			
};

#if defined(M_I386) || defined(i386)
#pragma pack()
#endif

/* defines for ibm console ioctls */
#define CONSIOC		('c' << 8)
#define CONS_CURRENT 	(CONSIOC|1)
#define CONS_GET	(CONSIOC|2)
#define CONSIO		(CONSIOC|3)
#define CONS_BLANKTIME	(CONSIOC|4)
#define CONS_BLANKSCRN	(CONSIOC|5)
#define CONS_UNBLANKSCRN	(CONSIOC|6)
#define CONS_DISPLAYED	(CONSIOC|7)

#define PIO_FONT8x8	(CONSIOC|64)
#define GIO_FONT8x8	(CONSIOC|65)
#define PIO_FONT8x14	(CONSIOC|66)
#define GIO_FONT8x14	(CONSIOC|67)
#define PIO_FONT8x16	(CONSIOC|68)
#define GIO_FONT8x16	(CONSIOC|69)

#define CONSADP		(CONSIOC|72)	/* get specific adapter screen */
#define CONS_GETINFO	(CONSIOC|73)	/* get vid_info struct S001 */
#define CONS_6845INFO	(CONSIOC|74)	/* get m6845_info struct S001 */

/* defines for inb/outb ioctls for graphics adapter ports */
#define IN_ON_PORT	1
#define OUT_ON_PORT	0

#if defined(M_I386) || defined(i386)
#pragma pack(2)
#endif

/* structure used for inb/outb ioctls for graphics adapter ports */
struct port_io_struct {
	char	dir;	/* direction flag (in vs. out) */
	unsigned short port;
	char	data;
};
struct port_io_arg {
	struct port_io_struct args[4];
};	

#if defined(M_I386) || defined(i386)
#pragma pack()
#endif

#endif	/* _SYS_CONSOLE_H */
