#ident	"@(#)ciscsi.h	1.2	90/08/08"
#ifndef _SYS_CI_CISCSI_H
#define _SYS_CI_CISCSI_H
#ident "@(#) ciscsi.h 1.1 90/05/30 "
/*
 *	Copyright (C) Corollary, Inc., 1986, 1987, 1988, 1989, 1990.
 *	All Rights Reserved.
 *	This Module contains Proprietary Information of
 *	Corollary, Inc., and should be treated as Confidential.
 */

/*
 *	Corollary Inc. SCSI multiprocessor driver
 *	definitions for the Corollary ATtack architecture
 */

#pragma pack(1)
struct ext_mb {
	uchar_t	emb_message;
	uchar_t emb_message_length;
	uchar_t emb_code;
	uchar_t emb_sync_period;
	uchar_t emb_sync_offset;
};
#pragma pack()

struct rd_cap {
	long	cap_lblk;			/* max logical block */
	long	cap_blksz;			/* block size */
};

#pragma pack(1)
struct blk_lim {
	union {
		struct blk1 {
			uchar_t	limreserved;
			uchar_t	limmaxb[3];
		} blk_blk1;
		int limmax;
	} blk_u;
	short	lim_min;
};
#pragma pack()
#define lim_reserved		blk_u.blk_blk1.limreserved
#define lim_maxb		blk_u.blk_blk1.limmaxb
#define lim_max			blk_u.limmax

struct rd_inq {
	uchar_t	inq_device_type;
	uchar_t	inq_device_qual;
	uchar_t	inq_version;
	uchar_t	inq_reserved;
	uchar_t	inq_additional_length;
	uchar_t	inq_tmp[3];
};
/*
 *  device type
 */
#define I_DA_DEVICE		0x00
#define I_SA_DEVICE		0x01
#define I_NOT_PRESENT		0x7f

#pragma pack(1)
struct rq_sense {
	uchar_t rq_error_code:4;
	uchar_t rq_error_class:3;
	uchar_t rq_valid:1;
	uchar_t rq_segment_number;
	union {
		struct rq1 {
			uchar_t rq_sensekey:4;
			uchar_t rq_reserved:1;
			uchar_t rq_ili:1;
			uchar_t	rq_eom:1;
			uchar_t	rq_filemark:1;
		} rq_rq1;
		uchar_t	rq_sense_byte;
	} rq_u;
	long rq_information;
};
#pragma pack()
#define rq_sense_key		rq_u.rq_rq1.rq_sensekey
#define rq_sense_data		rq_u.rq_sense_byte
/*
 *  error class defines
 */
#define EXTENDED_SENSE		0x07
/*
 *  sense key defines
 */
#define UNIT_ATTENTION		0x06

/*
 *  SCSI command block
 */
#pragma pack(1)
struct cb {
	uchar_t	cb_opcode;
	union {
		struct cb1 {
			uchar_t cb_lba_hi:5;
			uchar_t	cb_unt:3;
			uchar_t cb_lba_mid;
			uchar_t cb_lba_lo;
		} cb_cb1;
		uchar_t cb_lba[3];
	} cb_u;
	uchar_t	cb_transfer_length;
	uchar_t	cb_control_byte;
};
#pragma pack()
#define cb_unit			cb_u.cb_cb1.cb_unt
#define cb_block_address	cb_u.cb_lba

/*
 * extended control block
 */
#pragma pack(1)
struct ecb {
	uchar_t	ecb_opcode;
	union {
		struct ecb1 {
			uchar_t ecb_reladr:1;
			uchar_t ecb_reserved1:4;
			uchar_t	ecb_unt:3;
		} ecb_ecb1;
		uchar_t ecb_unit;
	} ecb_u;
	uchar_t	ecb_block_address[4];
	uchar_t	ecb_reserved;
	uchar_t	ecb_transfer_length[2];
	uchar_t	ecb_control_byte;
};
#pragma pack()
#define ecb_unit		ecb_u.ecb_unit

/*
 *  user ioctl interface
 */
struct uio {
	char	uio_ecbf;
	char	uio_rcvf;
	uchar_t	uio_cb[sizeof(struct ecb)];
	uchar_t	*uio_buf;
	int	uio_buflen;
	int	uio_timeval;
};

/*
 *  user ioctl equates
 */
#define SCSIIOC			('S'<<8)
#define SCSI_PASSTHRU		(SCSIIOC|1)

/*
 *  SCSI commands
 */
#define	SCSI_TEST_UNIT_READY	0x00
#define SCSI_SYNC_XFER_REQUEST	0x01
#define SCSI_REWIND		0x01
#define SCSI_REQUEST_SENSE	0x03
#define SCSI_FORMAT_UNIT	0x04
#define SCSI_READ_BLOCK_LIMITS	0x05
#define SCSI_READ		0x08
#define SCSI_WRITE		0x0a
#define SCSI_WRITE_FILEMARKS	0x10
#define SCSI_SPACE		0x11
#define	SCSI_INQUIRY		0x12
#define SCSI_MODE_SELECT	0x15
#define SCSI_ERASE		0x19
#define SCSI_MODE_SENSE		0x1a
#define SCSI_START_STOP_UNIT	0x1b
#define SCSI_LOAD		0x1b
#define SCSI_MEDIUM_REMOVAL	0x1e
#define SCSI_READ_CAPACITY	0x25
#define SCSI_PASS_THRU		0x59

/*
 *  SCSI message byte
 */
#define M_COMMAND_COMPLETE	0x00
#define M_EXTENDED_MESSAGE	0x01
#define M_SAVE_DATA_POINTER	0x02
#define M_RESTORE_POINTERS	0x03
#define M_DISCONNECT		0x04
#define M_INITIATOR_DETECT_ERR	0x05
#define M_ABORT			0x06
#define M_MESSAGE_REJECT	0x07
#define M_NO_OPERATION		0x08
#define M_MESSAGE_PARITY_ERROR	0x09
#define M_LINK_COM_COMPLETE	0x0a
#define M_LINK_COM_COMPLETE_WF	0x0b
#define M_IDENTIFY		0x80
#define M_SUPPORT_DISCONNECT	0x40

/*
 *  SCSI status byte
 */
#define ST_GOOD			0x00
#define ST_CHECK_CONDITION	0x02
#define ST_BUSY			0x08

/*
 *  SCSI phases
 */
#define DATA_OUT		0x00
#define DATA_IN			0x01
#define COMMAND			0x02
#define STATUS			0x03
#define MESSAGE_OUT		0x06
#define MESSAGE_IN		0x07

/*
 * 30 second timeout value
 */
#define	SCMP_TIMEOUT		30
#endif /* _SYS_CI_CISCSI_H */
