#ident	"@(#)atcioctl.h	1.2	90/08/08"
#ifndef _SYS_CI_ATCIOCTL_H
#define _SYS_CI_ATCIOCTL_H
#ident "@(#) atcioctl.h 1.1 90/05/30 "
/*
 *      Copyright (C) Corollary, Inc., 1986, 1987, 1988, 1989, 1990.
 *      All Rights Reserved.
 *      This Module contains Proprietary Information of
 *      Corollary, Inc., and should be treated as Confidential.
 */

/*
 *	Corollary Inc. terminal concentrator ioctl support
 */

#define MAXDEFLEN 256

struct tpdefparam {
	char	name[8];		/* name given to escape definition   */
	short	len;			/* length of escape definition	     */
	char	escape;			/* character that starts escape seq. */
	char	data[MAXDEFLEN];	/* escape definition table	     */
};

struct tpparam {
	short	rate;			/* cps to send to printer	     */
	char	tabname[8];		/* name given to esctab for id	     */
	char	enterstr[8];		/* string to turn trans. print on    */
	char	enterlen;		/* length of enter string	     */
	char	exitstr[8];		/* string to turn trans. print off   */
	char	exitlen;		/* length of exit string	     */
};

struct tcrev {
	int	muxrev;			/* mux revision number		     */
	char	driverrev[16];		/* driver revision number	     */
};

#define ATMIOC		('A' << 8)
#define ATMTCREV 	(ATMIOC | 0)	/* get mux revision number	     */

#define MXCIOC		(0x84 << 8)
#define MXCIOCPNL	(MXCIOC | 0)	/* output periodic newline */
#define MXCIOCGTP	(MXCIOC | 1)	/* get transparent print parameters */
#define MXCIOCSTP	(MXCIOC | 2)	/* set transparent print parameters */
#define MXCIOCLDEF	(MXCIOC | 3)	/* load escape sequence definition */
#define MXCIOCWHERE	(MXCIOC | 4)	/* where is this tty */
#define MXCIOCSETDEF	(MXCIOC | 5)	/* go into "set default" mode */
#define MXCIOCUNSETDEF	(MXCIOC | 6)	/* exit "set default" mode */
#define MXCIOCRESETDEF	(MXCIOC | 7)	/* go back to UNIX std tty params */
#define MXCIOCLOCKIXON	(MXCIOC | 8)	/* lock IXON mode on */
#define MXCIOCUNLKIXON	(MXCIOC | 9)	/* allow IXON to vary */
#define MXCIOCHUPCTL	(MXCIOC | 10)	/* SIGHUP on carrier change */
#define MXCIOCDTR	(MXCIOC | 11)	/* DTR control */
#define MXCIOCRTS	(MXCIOC | 12)	/* RTS control */
#define MXCIOCTCCMD	(MXCIOC | 13)	/* raw TC command */
#define MXCIOCDSR	(MXCIOC | 14)	/* read DSR state */

#define ET_NOMODEM	0x0	/* no modem control */
#define ET_MODEMCTL	0x1	/* use modem control */
#define ET_PRINTQ	0x2	/* use printer output queue */
#define ET_OVERRIDE	0x4	/* use etty->defaults instead of standard */
#define ET_LOCKIXON	0x8	/* force IXON mode always */
#define ET_OASLP	0x100	/* output sleeping */
#define ET_RESUMETMO	0x200	/* resume timeout pending */
#define ET_EXCL		0x400	/* tty opened exclusively */
#define ET_SETDEF	0x800	/* in process of setting etty->defaults */
#endif /* _SYS_CI_ATCIOCTL_H */
