/*
 *	Copyright (c) 1990-1991 Altos Computer Systems
 *	All Rights Reserved.
 *
 *	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ALTOS
 *	The copyright notice above does not evidence any
 *	actual or intended publication of such source code.
 *
 */

#ident	"@(#)biob.h	1.4 91/01/15"

/* ____________ Macros for determining Slot-Specific I/O Register Address _ */

#define	REG_ADDR(slot, addr)	((slot<<12) | addr)

#define CR_1(slot)		REG_ADDR(slot, 0x0c84)
#define CR_2(slot)		REG_ADDR(slot, 0x0cc0)
#define CR_3(slot)		REG_ADDR(slot, 0x0cf3)
#define CR_4(slot)		REG_ADDR(slot, 0x0cf0)
#define CR_5(slot)		REG_ADDR(slot, 0x0cf1)
#define CR_6(slot)		REG_ADDR(slot, 0x0020)
#define SP_1(slot)		REG_ADDR(slot, 0x0cd1)
#define SP_2(slot)		REG_ADDR(slot, 0x0cf2)
#define CA(slot)		REG_ADDR(slot, 0x0cd0)
#define PORT(slot)		REG_ADDR(slot, 0x0cd2)
#define ENET_PROM(slot, off)	REG_ADDR(slot, 0x0c90 + (off & 0xf))

/* devtype */

#define	B_COM1	0
#define	B_COM2	1
#define	B_LPT1	2
#define	B_FLOP	3
#define	B_SCSI	4
#define	B_ENET	5
#define B_ALL	6


/* ____________ CR_1: Expansion Board Control Register ____________________ */

#define DISABLE_BIOB		0x00
#define ENABLE_BIOB		0x01


/* ____________ CR_5: Interrupt Mode Register _____________________________ */

#define EISA_MODE	0x40
#define ENABLE_INTR	0x80


/* ____________ CR_6: SCSI DMA Direction Register _________________________ */

#define SCSI_DMA_WRITE 	0x00	/* DMA Read from mem, Write to SCSI         */
#define SCSI_DMA_READ 	0x01	/* DMA Write to mem, Read from SCSI         */


/* ____________ SP_1: Ethernet Hardware Configuration Status Port __________ */

#define ENET_BOARD	0x01	/* 1 = ENET daughter board installed        */
#define ENET_THICK	0x02	/* 0 = Thick cabling		            */
#define ENET_THIN	0x04	/* 0 = Thin cabling		            */
#define ENET_TWIST	0x08	/* 0 = Twisted pair cabling	            */
#define ENET_VERSION	0x80	/* 1 = Vers 2, 0 = Vers 1	            */

/* Bit 0 defines (ENET_BOARD) */
#define INSTALLED	0	/* Daughter board installed		    */
#define NOTINSTALLED	1	/* Daughter board not installed		    */

/* Bit 7 defines (ENET_VERSION) */
#define SP_1_ENET_V2	0x80		/* Version 2                        */
#define SP_1_ENET_V1	0		/* Version 1                        */


/* ____________ SP_2: Interrupt Reason Status Port _________________________ */

#define COM1_INTR	0x01	/* 1 = Interrupt pending on COM1 Port       */
#define COM2_INTR	0x02	/* 1 = Interrupt pending on COM2 Port       */
#define LPT1_INTR	0x04	/* 1 = Interrupt pending on Parallel Port   */
#define FLOP_INTR	0x08	/* 1 = Interrupt pending on Floppy Ctrller  */
#define SCSI_INTR	0x10	/* 1 = Interrupt pending on SCSI Controller */
#define ENET_INTR	0x20	/* 1 = Interrupt pending on Enet Controller */
#define ANY_INTR	0x80	/* 1 = One or more devices above have       */
				/*       pending interrupts.                */

/* ____________ Support Macros ____________________________________________ */

#define	intr_reason(slot)	    inb(SP_2(slot))

/*
 * Expansion Board Control Register:  CR_1
 *   Read-Write, 8-bit, Address = 0xZc84 (Z = slot number)
 *
 *   Enables/Disables I/O Board.
 */
#define enable_board(slot)	    outb(CR_1(slot),1)
#define disable_board(slot)	    outb(CR_1(slot),0)

/*
 * Interrupt Mode Register:  CR_5
 *   Write-Only, 8-bit, Address = 0xZcf1 (Z = slot number)
 *
 *   Masks/Unmask interrupt from specified device.
 *   Enables/Disables interrupt.
 *   Sets board to EISA/AT mode.
 */
#define mask_intr(device, slot)	    outb(CR_5(slot),biob_cr5[slot] |= cr5map[device])
#define unmask_intr(device, slot)   outb(CR_5(slot),biob_cr5[slot] &= ~cr5map[device])
#define enable_intr(slot)	    outb(CR_5(slot),biob_cr5[slot] |= 0x80)
#define disable_intr(slot)	    outb(CR_5(slot),biob_cr5[slot] &= ~0x80)
#define set_eisa_mode(slot)	    outb(CR_5(slot),biob_cr5[slot] |= 0x40)
#define set_at_mode(slot)	    outb(CR_5(slot),biob_cr5[slot] &= ~0x40)


/*
 * Reset Register:  CR_3
 *   Write-Only, 8-bit, Address = 0xZcf3 (Z = slot number)
 *
 *   Holds the specified controller(s) in Reset/Active mode.
 */
#define reset_ctrl(device, slot)    outb(CR_3(slot),biob_cr3[slot] &= ~cr3map[device])
#define unreset_ctrl(device, slot)  outb(CR_3(slot),biob_cr3[slot] |= cr3map[device])

/*
 * SCSI DMA Direction Register:  CR_6
 *   Write-Only, 8-bit, Address = 0xZ020 (Z = slot number)
 *
 *   Sets direction of reads and writes to Memory and SCSI device.
 */
#define scsi_dma_read(slot)	    outb(CR_6(slot),biob_cr6[slot] = SCSI_DMA_READ)
#define scsi_dma_write(slot)	    outb(CR_6(slot),biob_cr6[slot] = SCSI_DMA_WRITE)

/*
 * Ethernet Channel Attention:  CA
 *   Write-Only, Address = 0xZcd0 (Z = slot number)
 *   Data doesn't matter - the write generates the CA
 */
#define enet_attn(slot)		    outb(CA(slot), 0)

/*
 * Ethernet Hardware Configuration Status Port:  SP_1
 *   Read-Only, 8-bit, Address = 0xZcd1 (Z = slot number)
 *
 *   Returns status byte specifying whether Ethernet Daughter Board
 *   has been installed, whether it is configured for thick or thin
 *   cabling, and what version of Ethernet is being used.  See 
 *   <sys/biob.h> for possible return values.
 */
#define enet_config(slot)	    inb(SP_1(slot))

/* ________________________________________________________________________ */

extern int init_biodev();
extern unsigned char biob_slot;

extern unsigned char biob_cr2[];	/* BIOS Base Address Register      */
extern unsigned char biob_cr3[];	/* Reset Register                  */
extern unsigned char biob_cr4[];	/* Interrupt Level Register        */
extern unsigned char biob_cr5[];	/* Interrupt Mode Register         */
extern unsigned char biob_cr6[];	/* SCSI DMA Direction Register     */
extern unsigned char cr3map[];
extern unsigned char cr5map[];
