#ident	"@(#)auditmsg.h	1.2	90/08/08"
#ifndef _SYS_AUDITMSG_H
#define _SYS_AUDITMSG_H
#ident "@(#) auditmsg.h 22.1 90/01/15 "
#ident "@(#)auditmsg.h	1.2 89/09/29"
#ident "@(#) auditmsg.h 1.10 89/07/27 "

/*
 *	Copyright (c) 1987 SecureWare, Inc.
 * @)#(auditmsg.h	2.2 16:23:12 1/30/89 SecureWare
 *
 *	This is proprietary source code of SecureWare, Inc.
 */

/*
 *	Audit Subsystem Utility Program Header. This header file
 *	contains message definitions constants for the audit subsystem.
 */


/*	System Call Messages	*/

static char UNUSED[] = "Unused";


char *syscall_msg[] = {
	"Indir",		/*  0=indir */
	"Exit",			/*  1=exit */
	"Fork",			/*  2=fork */
	"Read",			/*  3=read */
	"Write",		/*  4=write */
	"Open",			/*  5=open */
	"Close",		/*  6=close */
	"Wait",			/*  7=wait */
	"Creat",		/*  8=creat */
	"Link",			/*  9=link */
	"Unlink",		/* 10=link */
	"Exec",			/* 11=exec */
	"Chdir",		/* 12=chdir */
	"Time",			/* 13=time */
	"Mknod",		/* 14=mknod */
	"Chmod",		/* 15=chmod */
	"Chown",		/* 16=chown */
	"Break",		/* 17=break */
	"Stat",			/* 18=stat */
	"Seek",			/* 19=seek */
	"Getpid",		/* 20=getpid */
	"Mount",		/* 21=mount */
	"Umount",		/* 22=umount */
	"Setuid",		/* 23=setuid */
	"Getuid",		/* 24=getuid */
	"Stime",		/* 25=stime */
	"Ptrace",		/* 26=ptrace */
	"Alarm",		/* 27=alarm */
	"Fstat",		/* 28=fstat */
	"Pause",		/* 29=pause */
	"Utime",		/* 30=utime */
	"Stty",			/* 31=stty */
	"Gtty",			/* 32=gtty */
	"Access",		/* 33=access */
	"Nice",			/* 34=nice */
#ifdef SYSV_3
	"Statfs",		/* 35=statfs */
#else
	"unused",		/* 35=unused */
#endif
	"Sync",			/* 36=sync */
	"Kill",			/* 37=kill */
#ifdef SYSV_3
	"Fstatfs",		/* 38=fstatfs */
#else
	UNUSED,			/* 38=unused */
#endif
	"Setpgrp",		/* 39=setpgrp */
	"unused",		/* 40=unused */
	"Dup",			/* 41=dup */
	"Pipe",			/* 42=pipe */
	"Times",		/* 43=times */
	"Prof",			/* 44=prof */
	"Plock",		/* 45=plock */
	"Setgid",		/* 46=setgid */
	"Getgid",		/* 47=getgid */
	"Signal",		/* 48=signal */
	"Msgsys",		/* 49=msgsys */
	"unused",		/* 50=unused */
	"Acct",			/* 51=acct */
	"Shmsys",		/* 52=shmsys */
	"Semsys",		/* 53=semsys */
	"Ioctl",		/* 54=ioctl */
#ifdef SYSV_3
	"Uadmin",		/* 55=uadmin */
#else
	UNUSED,			/* 55=unused */
#endif
	UNUSED,			/* 56=unused */
	"Utssys",		/* 57=utssys */
	UNUSED,			/* 58=unused */
	"Exece",		/* 59=exece */
	"Umask",		/* 60=umask */
	"Chroot",		/* 61=chroot */
	"Fcntl",		/* 62=fcntl */
	"Ulimit",		/* 63=ulimit */
	UNUSED,			/* 64=unused */
	UNUSED,			/* 65=unused */
#ifndef SYSV_3
	"Security",		/* 66=security */
#endif
#ifdef SYSV_3
	UNUSED,			/* 66=unused */
	UNUSED,			/* 67=unused */
	UNUSED,			/* 68=unused */
	UNUSED,			/* 69=unused */
	"Advfs",		/* 70=advfs */
	"Unadvfs",		/* 71=unadvfs */
	"Rmount",		/* 72=rmount */
	"Rumount",		/* 73=rumount */
	"Rfstart",		/* 74=rfstart */
	UNUSED,			/* 75=unused */
	"Rdebug",		/* 76=rdebug */
	"Rfstop",		/* 77=rfstop */
	"Rfsys",		/* 78=rfsys */
	"Rmdir",		/* 79=rmdir */
	"Mkdir",		/* 80=mkdir */
	"Getdents",		/* 81=getdents */
	UNUSED,			/* 82=unused */
	UNUSED,			/* 83=unused */
	"Sysfs",		/* 84=sysfs */
	"Getmsg",		/* 85=getmsg */
	"Putmsg",		/* 86=putmsg */
	"Poll",			/* 87=poll */
#if defined(M_XENIX) 
	UNUSED,			/* 88=unused */
	"Security",		/* 89=security */
#endif
#ifdef M_XENIX
	UNUSED,			/* 90=unused */		/* Xenix calls */
	"Locking",		/* 91=locking */
	"Creatsem",		/* 92=creatsem */
	"Opensem",		/* 93=opensem*/
	"Sigsem",		/* 94=sigsem*/
	"Waitsem",		/* 95=waitsem */
	"Nbwaitsem",		/* 96=nbwaitsem */
	"Rdchk",		/* 97=rdchk */
	UNUSED,			/* 98 */
	UNUSED,			/* 99 */
	"Chsize",		/* 100=chsize */
	"Ftime",		/* 101=ftime */
	"Nap",			/* 102=nap */
	"Sdget",		/* 103=sdget */
	"Xsdfree",		/* 104=xsdfree */
	"Sdenter",		/* 105=sdenter */
	"Sdleave",		/* 106=sdleave */
	"Sdgetv",		/* 107=sdgetv */
	"Sdwaitv",		/* 108=sdwaitv */
	UNUSED,			/* 109 */
	UNUSED,			/* 110 */
	UNUSED,			/* 111 */
	UNUSED,			/* 112 */
	UNUSED,			/* 113 */
	UNUSED,			/* 114 */
	UNUSED,			/* 115 */
	UNUSED,			/* 116 */
	UNUSED,			/* 117 */
	UNUSED,			/* 118 */
	UNUSED,			/* 119 */
	UNUSED,			/* 120 */
	UNUSED,			/* 121 */
	"Proctl",		/* 122=proctl */
	"Execseg",		/* 123=execseg */
	"Unexecseg",		/* 124=unexecseg */
	UNUSED,			/* 125 */
#endif
#endif
};

#ifdef SYSV_3

#if defined(M_XENIX)
#define AUDIT_MAX_SYSCALL	125
#endif



#else

#define AUDIT_MAX_SYSCALL	66

#endif


struct error_msg {
	char	*name;		/* error name */
	char	*text;		/* error message text */
};

struct error_msg error_msg[] = {
	"Successful",	"",				/* No error */
	"EPERM",	"Not owner",			/* 1 */
	"ENOENT",	"No such file or directory",	/* 2 */
	"ESRCH",	"No such process",		/* 3 */
	"EINTR",	"Interrupted system call",	/* 4 */
	"EIO",		"I/O error",	 		/* 5 */
	"ENXIO",	"No such device or address",	/* 6 */
	"E2BIG",	"Arg list too long",		/* 7 */
	"ENOEXEC",	"Exec format error",		/* 8 */
	"EBADF",	"Bad file number",		/* 9 */
	"ECHILD",	"No child processes",		/* 10 */
	"EAGAIN",	"No more processes",		/* 11 */
	"ENOMEM",	"Not enough space",		/* 12 */
	"EACCES",	"Permission denied",		/* 13 */
	"EFAULT",	"Bad address",			/* 14 */
	"ENOTBLK",	"Block device required",	/* 15 */
	"EBUSY",	"Device or resource busy",	/* 16 */
	"EEXIST",	"File exists",			/* 17 */
	"EXDEV",	"Cross-device link",		/* 18 */
	"ENODEV",	"No such device",		/* 19 */
	"ENOTDIR",	"Not a directory",		/* 20 */
	"EISDIR",	"Is a directory",		/* 21 */
	"EINVAL",	"Invalid argument",		/* 22 */
	"ENFILE",	"File table overflow",		/* 23 */
	"EMFILE",	"Too many open files",		/* 24 */
	"ENOTTY",	"Not a character device",	/* 25 */
	"ETXTBSY",	"Text file busy",		/* 26 */
	"EFBIG",	"File too large",		/* 27 */
	"ENOSPC",	"No space on device",		/* 28 */
	"ESPIPE",	"Illegal seek",			/* 29 */
	"EROFS",	"Read-only file system",	/* 30 */
	"EMLINK",	"Too many links",		/* 31 */
	"EPIPE",	"Broken pipe",			/* 32 */
	"EDOM",		"Math argument",		/* 33 */
	"ERANGE",	"Result too large",		/* 34 */
	"ENOMSG",	"No message of desired type",	/* 35 */
	"EIDRM",	"Identifier removed",		/* 36 */
#if defined(SYSV_3) 
	"ECHRNG",	"Channel number out of range",	/* 37 */
	"EL2NSYNC",	"Level 2 not synchronized",	/* 38 */
	"EL3HLT",	"Level 3 halted",		/* 39 */
	"EL3RST",	"Level 3 reset",		/* 40 */
	"ELNRNG",	"Link number out of range",	/* 41 */
	"EUNATCH",	"Protocol driver not attached",	/* 42 */
	"ENOCSI",	"No CSI structure available",	/* 43 */
	"EL2HLT",	"Level 2 halted",		/* 44 */
#else
	"",		"",				/* 37 */
	"",		"",				/* 38 */
	"",		"",				/* 39 */
	"",		"",				/* 40 */
	"",		"",				/* 41 */
	"",		"",				/* 42 */
	"",		"",				/* 43 */
	"",		"",				/* 44 */
#endif
	"EDEADLK",	"Deadlock",			/* 45 */
	"ENOLCK",	"No lock",			/* 46 */
	"",		"",				/* 47 */
	"",		"",				/* 48 */
	"",		"",				/* 49 */
	"",		"",				/* 50 */
	"",		"",				/* 51 */
	"",		"",				/* 52 */
	"",		"",				/* 53 */
	"",		"",				/* 54 */
	"",		"",				/* 55 */
	"",		"",				/* 56 */
	"",		"",				/* 57 */
	"",		"",				/* 58 */
	"",		"",				/* 59 */
	"ENOSTR",	"Device not a stream",		/* 60 */
	"ENODATA",	"No data",			/* 61 */
	"ETIME",	"Timer expired",		/* 62 */
	"ENOSR",	"Out of streams",		/* 63 */
	"ENONET",	"Not on network",		/* 64 */
	"ENOPKG",	"Package not installed",	/* 65 */
	"EREMOTE",	"Object is remote",		/* 66 */
	"ENOLINK",	"Link has been broken",		/* 67 */
	"EADV",		"Advertise error",		/* 68 */
	"ESRMOUNT",	"Srmount error",		/* 69 */
	"ECOMM",	"Communication error",		/* 70 */
	"EPROTO",	"Protocol error",		/* 71 */
	"",		"",				/* 72 */
	"",		"",				/* 73 */
	"EMULTIHOP",	"Mutilhop attempted",		/* 74 */
	"ELBIN",	"Inode is remote",		/* 75 */
	"EDOTDOT",	"Cross mount point",		/* 76 */
	"EBADMSG",	"Unreadable message",		/* 77 */
	"",		"",				/* 78 */
	"",		"",				/* 79 */
	"ENOTUNIQ",	"Logname not unique",		/* 80 */
	"EBADFD",	"Bad file descriptor for op",	/* 81 */
	"EREMCHG",	"Remote address changed",	/* 82 */
	"ELIBACC",	"Missing shared library",	/* 83 */
	"ELIBBAD",	"Corrupted shared library",	/* 84 */
	"ELIBSCN",	"Bad shared library section",	/* 85 */
	"ELIBMAX",	"Too many shared libraries",	/* 86 */
	"ELIBEXEC",	"Exec on shared library",	/* 87 */
};






#ifdef SYSV_3

#define AUDIT_MAX_ERRNO	87


#else

#define AUDIT_MAX_ERRNO	46


#endif


/*	Event Type Messages	*/

char *event_msg[] = {
	"Invalid Event",			/* 0 */
	"Startup/Shutdown activity",		/*  1 = ET_BOOT_DOWN */
	"Login/Logoff activity",		/*  2 = ET_LOGIN */
	"Process creation/deletion activity",	/*  3 = ET_PROCESS */
	"Make object available",		/*  4 = ET_OBJECT_AVAIL */
	"Map object to subject",		/*  5 = ET_OBJECT_MAP */
	"Modify object",			/*  6 = ET_OBJECT_MOD */
	"Make object unavailable",		/*  7 = ET_OBJECT_UNAVAIL */
	"Object creation",			/*  8 = ET_OBJECT_CREAT */
	"Object deletion",			/*  9 = ET_OBJECT_DEL */
	"Discretionary access change",		/* 10 = ET_DAC_CHANGE */
	"Access denial",			/* 11 = ET_ACCESS_DENIAL */
	"System administrator activity",	/* 12 = ET_SYS_ADMIN */
	"Insufficient privilege",		/* 13 = ET_INSUFF_PRIV */
	"Resource denial",			/* 14 = ET_RES_DENIAL */
	"Inter-process communication",		/* 15 = ET_IPC */
	"Modify process",			/* 16 = ET_PROCESS_MOD */
	"Audit subsystem activity",		/* 17 = ET_AUDIT */
	"Authentication database activity",	/* 18 = ET_DATABASE */
	"Privileged subsystem activity",	/* 19 = ET_SUBSYSTEM */
	"Use of Privilege",			/* 20 = ET_PRIVILEGE */
};

/*	System object types/database types */

char *objects[] = {
	"Invalid entry",		/* unused = 0 */
	"Regular file",			/* OT_REGULAR = 1  */
	"Directory",			/* OT_DIRECTORY = 2 */
	"Special device",		/* OT_DEVICE = 3 */
	"Pipe",				/* OT_PIPE = 4 */
	"Process",			/* OT_PROCESS = 5 */
	"Memory",			/* OT_MEMORY = 6 */
	"Stream",			/* OT_STREAM = 7 */
	"Socket",			/* OT_SOCKET = 8 */
	"Shared memory",		/* OT_SHARED_MEMORY = 9 */
	"Semaphore",			/* OT_SEMAPHORE = 10 */
	"Message queue",		/* OT_MESSAGE_QUEUE = 11 */
	"/etc/passwd database",		/* OT_PWD = 12 */
	"/etc/group database",		/* OT_GRP = 13 */
	"Protected password database",	/* OT_PRPWD = 14 */
	"Terminal control database",	/* OT_TERM_CNTL = 15 */
	"File control database",	/* OT_FILE_CNTL = 16 */
	"Command control database",	/* OT_CMD_CNTL = 17 */
	"System default database",	/* OT_DFLT_CNTL = 18 */
	"Subsystem database",		/* OT_SUBSYS = 19 */
	"Device assignment database",	/* OT_DEV_ASG = 20 */
};

#define AUDIT_MAX_OBJECT	20

/* Subsystem types */

char *subsystems[] = {
	"Authorization subsystem",	/* ST_AUTH = 0 */
	"Backup subsystem",		/* ST_BACKUP = 1 */
	"Memory subsystem",		/* ST_MEM = 2 */
	"Terminal subsystem",		/* ST_TERMINAL = 3 */
	"Line printer subsystem",	/* ST_LP = 4 */
	"Uucp subsystem",		/* ST_UUCP = 5 */
	"Cron subsystem",		/* ST_CRON = 6 */
	"System Administration Subsystem", /* ST_SYSADMIN = 7 */
	"Audit Subsystem",		/* ST_AUDIT = 8 */
};

#define AUDIT_MAX_SUBSYS 8

/*	Event category messages and their respective sub-code messages	*/


char *security_msg[] = {
	"Stopio",			/* SEC_STOPIO = 0 */
	"Getluid",			/* SEC_GETLUID = 1 */
	"Setluid",			/* SEC_SETLUID = 2 */
	"Statpriv",			/* SEC_STATPRIV = 3 */
	"Chpriv",			/* SEC_CHPRIV = 4 */
};

#define AUDIT_MAX_SECURITY	4

char *priv_msg[] = {
	"unused privilege",		/* invalid */
	"Effective privilege",		/* SEC_EFFECTIVE_PRIV */
};

#define AUDIT_MAX_PRIVILEGE	1

char *priv_names[] = {
	"suspendaudit",
	"configaudit",
	"writeaudit",
	"suid",
	"promain",
	"label_terminal",
	"setid",
	"setowner",
};

#define AUDIT_C2_PRIVS	8

char *policy_name[] = {
	"Discretionary",
};

char *msgsys_msg[] = {
	"Msgget",
	"Msgctl",
	"Msgrcv",
	"Msgsnd",
};

char *shmsys_msg[] = {
	"Shmat",
	"Shmctl",
	"Shmdt",
	"Shmget",
};

char *semsys_msg[] = {
	"Semctl",
	"Semget",
	"Semop",
};

char *boot_msg[] = {
	"Invalid entry",
	"Kernel startup",		/* ES_KERNEL_STARTUP */
	"Kernel shutdown",		/* ES_KERNEL_SHUTDOWN */
};

char *login_msg[] = {
	"Invalid entry",
	"Successful login",		/* ES_LOGIN */
	"Unsuccessful login",		/* ES_LOGIN_FAILED */
	"Logoff",			/* ES_LOGOFF */
};

char *passwd_msg[] = {
	"Invalid entry",
	"Successful password change",		/* ES_PW_CHANGE */
	"Unsuccessful password change",		/* ES_PW_CHANGE_FAILED */
	"Insufficient privilege for password change", /* ES_PW_CHANGE_NOPRIV */
};

char *lock_msg[] = {
	"Invalid entry",
	"User account locked",				/* ES_USER_LOCK */
	"Terminal locked",				/* ES_TERM_LOCK */
	"User account locked by administrator",		/* ES_SET_USER_LOCK */
	"User account unlocked by administrator",	/* ES_SET_USER_UNLOCK */
	"Terminal locked by administrator",		/* ES_SET_TERM_LOCK */
	"Terminal unlocked by administrator",		/* ES_SET_TERM_UNLOCK */
};

char *audit_msg[] = {
	"Invalid entry",
	"Audit enabled",			/* ES_AUD_ENABLE */
	"Audit disabled",			/* ES_AUD_DISABLE */
	"Audit parameter modification",		/* ES_AUD_MODIFY */
	"Audit report generated",		/* ES_AUD_REPORT */
	"Audit file archival",			/* ES_AUD_ARCHIVE */
	"Audit recovery initiated",		/* ES_AUD_REC_INIT */
	"Audit recovery completed",		/* ES_AUD_REC_END */
	"Audit daemon initiated",		/* ES_AUD_DMN_INIT */
	"Audit daemon terminated",		/* ES_AUD_DMN_END */
	"Audit subsystem shutdown",		/* ES_AUD_SHUTDOWN */
	"Audit subsystem error occurred",	/* ES_AUD_ERROR */
};

char *database_msg[] = {
	"Invalid entry",
	"Authorization database integrity problem",   /* ES_DB_INTEGRITY */
	"Filesystem integrity problem",		      /* ES_FS_INTEGRITY */
	"Authorization database resource denial",     /* ES_DB_RESOURCE */
	"Security action failure in authorization database", /*ES_SEC_FAILURE */
};

/*	Array of pointers to record type messages-allows the record
	type and event subcode to be used as 2-dimensional array
	indices to print the needed message.			*/

char **rt_msg[] = {
	(char **)0,		/* RT_INVALID = 0 */
	(char **)0,		/* RT_SYSCALL = 1 */
	(char **)0,		/* RT_SYSCALL1 = 2 */
	(char **)0,		/* RT_SYSCALL2 = 3 */
	security_msg,		/* RT_SECURITY  = 4 */
	(char **)0,		/* RT_ID_CHANGE = 5 */
	(char **)0,		/* RT_DAC_CHANGE = 6 */
	boot_msg,		/* RT_BOOT_DOWN = 7 */
	(char **)0,		/* not used = 8  */
	(char **)0,		/* not used = 9 */
	(char **)0,		/* RT_COLLFILE = 10 */
	(char **)0,		/* RT_COMPFILE = 11 */
	(char **)0,		/* not used = 12 */
	(char **)0,		/* not used = 13 */
	(char **)0,		/* not used = 14 */
	(char **)0,		/* not used = 15 */
	(char **)0,		/* not used = 16 */
	(char **)0,		/* not used = 17 */
	(char **)0,		/* not used = 18 */
	(char **)0,		/* not used = 19 */
	login_msg,		/* RT_LOGIN = 20 */
	passwd_msg,		/* RT_PASSWORD = 21 */
	lock_msg,		/* RT_LOCK = 22 */
	(char **)0,		/* RT_LABEL = 23 */
	audit_msg,		/* RT_AUDIT = 24 */
	database_msg,		/* RT_DATABASE = 25 */
	(char **)0,		/* RT_SUBSYSTEM = 26 */
	(char **)0,		/* not used = 27 */
	(char **)0,		/* not used = 28 */
	(char **)0,		/* not used = 29 */
	(char **)0,		/* not used = 30*/
};

#endif	/* _SYS_AUDITMSG_H */
