#ident "@(#)adaptec.h	1.4 90/11/16"

#ifndef _SYS_ADAPTEC_H
#define _SYS_ADAPTEC_H
#ident	"@(#) adaptec.h 22.1 90/01/15 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1987, 1988, 1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 */

/* do not change these defines unless you know what you're doing	*/

#define NIDS		8		/* number of id's possible	*/
#define	NMAILBOX 	((NIDS-1)*2)	/* two mailbox pairs/target	*/
#define	NCCB	 	((NIDS-1)*2)	/* two ccb's/target		*/

#define SECTORS		32		/* sectors/track for disks	*/
#define	R_LIMIT		0x20000L	/* bit spin loop limit		*/
#define SGLEN		16		/* 16 entries in s-g list	*/

#define	ISRDWR(x) \
	((x)->scsi_cmd.raw[0] == READ_CMD || (x)->scsi_cmd.raw[0] == WRITE_CMD)

#define req_back	s2		/* we use REQ_IO.s2 as back ptr	*/
#define q_back		q_hd.req_back
#define q_forw		q_hd.req_forw

struct mbo {			/* host / adapter mailboxes out	*/
	char	cmd;		/* the command for the adapter	*/
	char	ccb_adr[3];	/* pointer to CCB for command	*/
};
typedef struct mbo MBO;

struct mbi {			/* host / adapter mailboxes in	*/
	char	stat;		/* completion status		*/
	char	ccb_ptr[3];	/* pointer to CCB for status	*/
};
typedef struct mbi MBI;

struct	mailboxes {		/* the mailbox SET		*/
	struct	mbo mbout[NMAILBOX];
	struct	mbi mbin[NMAILBOX];
};
typedef struct mailboxes MAILBOXES;

struct sg_list {
	unsigned char length[3];
	unsigned char data[3];
};
typedef struct sg_list SGLIST;

struct ccb {			/* command description block	*/
	char	opcode;
	char	target;		/* target ID and LUN		*/
	char	cmd_length;	/* CMDLENGTH			*/
	char	res0;
	char	length[3];
	char	pointer[3];
	char	link[3];
	char	link_id;
	char	host_status;
	char	unit_status;
	char	res1[2];
	char	scsi_cmd[CMDLENGTH];
	char	scsi_sense[SENSE_LEN];

	/* below is only used by the driver	*/

	char	use_flag;	/* zero if available			*/
	char	internal;	/* driver internal request if non-zero	*/
	char	jq;		/* job queue index			*/
	char	ctlr;		/* controller address			*/
	char	unit;		/* addevices index for adintr		*/
	char	type;		/* addevices index for adintr		*/
	char	mbi_status;	/* mbi status at adintr time		*/
	MBO	mboxo;		/* only used during debug...		*/
	char	adapter;	/* adapter base address			*/
	char	r_count;	/* retry count				*/
	struct	buf * rbuf;	/* request per this buf if non zero	*/
	REQ_IO	*request;	/* scsi_io_req pointer			*/
	SGLIST  sglist[SGLEN];	/* scatter-gather list 			*/
};
typedef struct ccb CCB;

struct aha_q {
	REQ_IO  q_hd;		/* the head of the queue	         */
	REQ_IO *q_actf;		/* first active req_io	                 */
	REQ_IO *q_actl;		/* last (i.e. most recent) active req_io */
	int	q_cnt;		/* number of req's on the queue          */
	int	q_acnt;		/* count of active requests	         */
};
typedef struct aha_q AHA_Q;

				/* Adapter commands		*/
#define	NOOP		0x00	/* no operation			*/
#define	MB_INIT		0x01	/* initialize mailboxes		*/
#define	ST_SCSI		0x02	/* start SCSI command		*/
#define	ST_BIOS		0x03	/* start BIOS command		*/
#define	AD_INQ		0x04	/* adapter inquiry		*/
#define	EN_MBO		0x05	/* enable MBO ints		*/
#define	SEL_TO		0x06	/* set selection timeout	*/
#define	BUS_ON		0x07	/* set bus on time		*/
#define	BUS_OFF		0x08	/* set bus off time		*/
#define	XFER_SPD	0x09	/* set xfer speed		*/
#define	RET_INS		0x0A	/* return installed devices	*/
#define	RET_CFG		0x0B	/* return configuration data	*/

				/* opcodes			*/
#define AHA_NORM	0x00	/* normal operation		*/
#define AHA_SG		0x02	/* scatter/gather operation	*/
#define AHA_SG_R	0x04	/* scatter/gather w/resid	*/

				/* auto-request sense length	*/
#define AHA_RS_14BYTE	0x00	/* 14 bytes of sense data	*/
#define AHA_RS_DISABLE	0x01	/* disable auto_sense		*/

				/* adapter port definitions	*/
#define AD_CTL		0	/* control -w			*/
#define	HARD_RESET	0x80	/* adapter reset with diags	*/
#define	SOFT_RESET	0x40	/* adapter reset w/o diags	*/
#define	CLEAR_INT	0x20	/* clears adapter interrupt	*/
#define	SCSI_RESET	0x10	/* reset SCSI bus		*/

#define	AD_STATUS	0	/* status r-			*/
#define	ST_IP		0x80	/* self test in progress	*/
#define	DIAG_ERR	0x40	/* internal diags failed	*/
#define	INIT_REQ	0x20	/* initialization required	*/
#define	IDLE		0x10	/* adapter idle			*/
#define	HOST_WRT	0x08	/* host written to cmd/data	*/
#define	ADAP_WRT	0x04	/* adapter written to cmd/data	*/
#define	AD_INVALID	0x01	/* invalid adapter command	*/
#define	AD_PRESENT	(IDLE | INIT_REQ) /* expected initial status */
#define	AD_PRESENT_BUT	(ST_IP | IDLE | INIT_REQ) /* tolerated */
#define	AD_BAD		(DIAG_ERR | ADAP_WRT) /* failed internal tests */


#define	AD_CMD_DATA	1	/* command and data port	*/

#define	AD_INTR		2	/* interrupt r-			*/
#define	AD_HAS_INT	0x80	/* one of the below pending	*/
#define	SR_DETECTED	0x08	/* SCSI reset detected		*/
#define	CMD_DONE	0x04	/* adapter command completed	*/
#define	MBO_EMPTY	0x02	/* MBO empty interrupt		*/
#define	MBI_STORED	0x01	/* MBI stored interrupt		*/

				/* MBO command bytes		*/
#define	MBO_FREE	0x00	/* mailbox free			*/
#define	MBO_START	0x01	/* start via the CCB address	*/
#define	MBO_ABORT	0x02	/* abort via the CCB address	*/

#define	MBI_FREE	0x00	/* mailbox free			*/
#define	MBI_DONE	0x01	/* command completed OK		*/
#define	MBI_ABORTED_OK	0x02	/* command aborted by host	*/
#define	MBI_ABORTED_BAD	0x03	/* aborted command not found	*/
#define	MBI_DONE_ERROR 	0x04	/* command completed w/ errors	*/
#define	MBI_LINKED_OK	0x0A	/* linked cmd completed OK	*/
#define	MBI_LINKED_BAD	0x0B	/* linked cmd completed BAD	*/
#define	MBI_TIMEOUT	0x11	/* selection time out		*/
#define	MBI_OVERRUN	0x12	/* data overrun			*/
#define	MBI_BUS_FREE	0x13	/* unexpected bus free		*/
#define	MBI_BUS_PHASE	0x14	/* target bus phase seq. error	*/
#define	MBI_COMMAND	0x15	/* MBO cmd was nor O1 or O2	*/

				/* Host status definitions	*/
#define	HOST_DONE	0x00	/* no adapter detected errors	*/
#define	HOST_LINKED_OK	0x0A	/* linked command completed ok	*/
#define	HOST_LINKED_BAD	0x0B	/* linked command completed bad	*/
#define	HOST_SEL_TO	0x11	/* selection timeout		*/
#define	HOST_DATA_OVER	0x12	/* data overrun			*/
#define	HOST_BUS_FREE	0x13	/* unexpected bus free		*/
#define	HOST_PHASE_ERR	0x14	/* target bus phase seq error	*/
#define	HOST_CMD	0x15	/* MBO cmd error		*/
#define	HOST_CCB_ERROR	0x16	/* invalid CCB			*/
#define	HOST_LINK_ERR	0x17	/* linked CCB to another LUN	*/

				/* Unit status definitions	*/
#define	UNIT_MASK	0x1e	/* status bits mask		*/
#define	UNIT_GOOD	0x00	/* success			*/
#define	UNIT_CHECK	0x02	/* check condition		*/
#define	UNIT_MET	0x04	/* condition met		*/
#define	UNIT_BUSY	0x08	/* busy				*/
#define	UNIT_INTERMED	0x10	/* intermediate cmd good	*/
#define	UNIT_INTMED_GD	0x14	/* intermediate cond met	*/
#define	UNIT_RESERV	0x18	/* reservation conflict		*/

#define	MB_OFF		0x00	/* disable mailbox out ints	*/
#define	MB_ON		0x01	/* allow mailbox out ints	*/

#define	TO_OFF		0x00	/* timeouts off			*/
#define	TO_ON		0x01	/* allow time outs		*/

#define	XFER_5_0	0x00	/* data xfer rate of 5.0 Mb	*/
#define	XFER_6_7	0x01	/*                   6.7	*/
#define	XFER_8_0	0x02	/*	             8.0	*/
#define	XFER_10		0x03	/*		    10.0	*/

#endif	/* _SYS_ADAPTEC_H */
