#ident	"@(#)82586.h	1.3	90/10/03"

#define A586VtoP(x)	((char *)(x) == NULL ? 0xffff : \
				((ushort)((char *)(x) - (char *) dev_p->virt_addr) + \
				(ushort)(0x10000 - dev_p->phys_addr_size)))

#define A586PtoV(x)	((ushort)(x) == 0xffff ? NULL : \
				((char *) dev_p->virt_addr + (ushort)(x) - \
				(0x10000 - dev_p->phys_addr_size)))


#define	EADDRSIZE	6	/* size of the MAC address */
#define	ETYPESIZE	2	/* size of the type/length field */
#define ETHER_MTU	1500	/* maximum size of an ethernet packet */
#define ETHER_MIN	46	/* minimum size of an ethernet packet */
#define MC_CNT		16	/* maximum number of multicast addresses */
#define MC_BIT		1	/* bit to identify multicast addresses in */
				/* the ethernet address */

/*
*	Board Specific defines
*/

#define RBUFSIZE	0x80	/* Receive Buffer size */ 
#define	N_RFDS		0x80	/* Number of Receive Frame Descriptors */

#define TBUFSIZE	ETHER_MTU	/* Transmit Buffer size */ 
#define	N_TBUFS		0x4	/* Number of Transmit Buffers */

#define DUMP_AREA	0xb0	/* Return area for a dump cmd - Largest */
				/* buffer required by a 82586 command */

#define OFFSET_SCP	0xfff6  /* 586's scp points to the iscp */
#define OFFSET_ISCP	0xffee	/* this points to the system control block */
#define OFFSET_SCB	0xffde  /* points to rcv frame and cmd unit areas */

#define OFFSET_RTN	OFFSET_SCB - DUMP_AREA
#define OFFSET_CB	OFFSET_RTN - sizeof(union cb) * N_TBUFS
#define OFFSET_TBD      OFFSET_CB - sizeof(struct tbd) * N_TBUFS
#define OFFSET_TBUF     OFFSET_TBD - sizeof(struct tbuf) * N_TBUFS
#define OFFSET_RFD	OFFSET_TBUF - sizeof(struct rfd) * N_RFDS

#define CMD_PORT	0x0	/* offset of board command register */
#define ENET_ADR_MASK	0x1f	/* address bits for ethernet address prom */
#define RESET_586	0x20	/* assert hardware reset to the 82586 */
#define CHAN_ATTN	0x40	/* assert channel attention to the 82586 */
#define LOOPBACK	0x80	/* assert loopback mode to the 82586 */

#define RAM_PORT	0x0	/* offset of board command register */
#define RAM_MASK	0xf	/* mask for the primary board ram addresses */
#define ADR_B000	0xc	/* comparison values for the board location */
#define ADR_C400	0xa
#define ADR_C800	0xb
#define ADR_D000	0x8
#define ADR_D400	0x9
#define ADR_E000	0x6
#define THINNET		0x10	/* cheapernet or AUI interface */
#define ADR_VALID	0x80	/* valid ram configuration */

#define IVEC_PORT	0x1	/* offset of board command register */
#define IVEC_MASK	0x7	/* mask bits determining interrupt level */
#define IRQ2		0x5	/* bus interrupt irq2 */
#define IRQ3		0x4	/* bus interrupt irq3 */
#define IRQ5		0x2	/* bus interrupt irq5 */
#define IRQ10		0x3	/* bus interrupt irq10 */
#define IRQ11		0x1	/* bus interrupt irq11 */
#define IRQ15		0x0	/* bus interrupt irq12 */

#define ADDR_PORT	0x2	/* offset of ethernet address register */

#define SPIN_TIME	0xf0000	/* time to wait for the 82586 to update the */
				/* control structures.  Chosen to be several */
				/* orders of magnitude larger than the real */
				/* time so faster processors can use this */


/*
* Constants and structs specific to the Intel 82586 Ethernet controller
*/

/*
* Commands
*/

#define NOP			0x00
#define IA_SETUP		0x01
#define CONFIG			0x02
#define MC_SETUP		0x03
#define TRANSMIT		0x04
#define TDR			0x05
#define DUMP			0x06
#define DIAGNOSE		0x07
#define CB_CMD_MASK		0x07

#define SCB_STAT_MASK		0xf000
#define SCB_CX			0x8000
#define SCB_FR			0x4000
#define SCB_CNA			0x2000
#define SCB_RNR			0x1000

#define CUS_MASK		0x700
#define CUS_IDLE		0x0
#define CUS_SUSP		0x100
#define CUS_ACT			0x200

#define RUS_MASK		0x70
#define RUS_IDLE		0x0
#define RUS_SUSP		0x10
#define RUS_NRSC		0x20
#define RUS_RDY			0x40

#define CU_NOP			0x0
#define CU_START		0x100
#define CU_RESUME		0x200
#define CU_SUSPEND		0x300
#define CU_ABORT		0x400

#define RU_NOP			0x0
#define RU_START		0x10
#define RU_RESUME		0x20
#define RU_SUSPEND		0x30
#define RU_ABORT		0x40

#define CB_C			0x8000
#define CB_B			0x4000
#define CB_OK			0x2000
#define CB_A			0x1000

#define CB_EL			0x8000
#define CB_S			0x4000
#define CB_I			0x2000 

#define TFD_NOCRS		0x400
#define TFD_NOCTS		0x200
#define TFD_DMA			0x100
#define TFD_DEFER		0x80
#define TFD_SQE			0x40
#define TFD_RETRY		0x20
#define TFD_COLL_MASK		0xf

#define RFD_CRC			0x400
#define RFD_ALIGN		0x400
#define RFD_NORSC		0x200
#define RFD_DMA			0x100
#define RFD_MIN			0x80
#define RFD_NOEOF		0x40

#define BD_EOF			0x8000
#define BD_F			0x4000
#define BD_CNT_MASK		0x3ff
#define BD_EL			0x8000
#define BD_SIZE_MASK		0x3ff

#define NULL586			0xffff

#pragma pack (1)

typedef struct eaddr {
	ushort saddr;
	uint laddr;
} enet_addr_t;

typedef struct scp {
	unchar	sysbus;
	char	fill[5];
	uint	iscp_address;
} scp_t;

typedef struct iscp {
	unchar	busy;
	char	fill;
	ushort	scb_offset;
	uint	scb_base;
} iscp_t;

typedef struct scb {
	ushort	status;
	ushort	command;
	ushort	cbl_offset;
	ushort	rfa_offset;
	ushort	crc_errs;
	ushort	aln_errs;
	ushort	rsc_errs;
	ushort	ovrn_errs;
} scb_t;

typedef struct cmd_cb {
	ushort	status;
	ushort	command;
	ushort	link_offset;
} cmd_cb_t;

typedef struct nop_cb {
	ushort	status;
	ushort	command;
	ushort	link_offset;
} nop_cb_t;

typedef struct ia_setup_cb {
	ushort	status;
	ushort	command;
	ushort	link_offset;
	struct eaddr host_addr;
} ia_setup_cb_t;

typedef struct config_cb {
	ushort	status;
	ushort	command;
	ushort	link_offset;
	unchar	params[12];
} config_cb_t;

typedef struct mc_setup_cb {
	ushort	status;
	ushort	command;
	ushort	link_offset;
	ushort	mc_cnt;
	struct eaddr mc_id[MC_CNT];
} mc_setup_cb_t;

typedef struct tdr_cb {
	ushort	status;
	ushort	command;
	ushort	link_offset;
	ushort	tdr_result;
} tdr_cb_t;

typedef struct dump_cb {
	ushort	status;
	ushort	command;
	ushort	link_offset;
	ushort	dump_area_offset;
} dump_cb_t;

typedef struct diagnose_cb {
	ushort	status;
	ushort	command;
	ushort	link_offset;
} diagnose_cb_t;

typedef struct tfd {
	ushort	status;
	ushort	command;
	ushort	link_offset;
	ushort	tbd_offset;
	struct eaddr dest_addr;
	ushort	length;
} tfd_t;

typedef struct tbd {
	ushort	status;
	ushort	tbd_offset;
	uint	tbuf_addr;
} tbd_t;

typedef struct tbuf {
	unchar	buf[TBUFSIZE];
} tbuf_t;

typedef union cb {
	struct cmd_cb cmd_cb;
	struct nop_cb nop;
	struct ia_setup_cb ia_setup; 
	struct config_cb config;
	struct mc_setup_cb mc_setup;
	struct tdr_cb tdr;
	struct dump_cb dump;
	struct diagnose_cb diagnose;
	struct tfd tfd;
} union_cb_t;

typedef struct rfd {
	ushort	status;
	ushort	command;
	ushort	link_offset;
	ushort	rbd_offset;
	struct eaddr dest_addr;
	struct eaddr src_addr;
	ushort	length;
} rfd_t;

typedef struct rbd {
	ushort	status;
	ushort	rbd_offset;
	uint	rbuf_addr;
	ushort	size;
} rbd_t;

typedef struct rbuf {
	unchar	buf[RBUFSIZE];
} rbuf_t;

#pragma pack ()
