/*
 * which - Shows the path name of an executable program specified.
 *	   Searches the directories listed in the PATH environment.
 *
 * by Ti Kan 2-5-86
 *
 * @(#)which.c	1.2	4/3/90 21:17:02
 */
#include <stdio.h>
#include <string.h>
#include <bool.h>
#include <sys/types.h>
#include <sys/stat.h>

extern char	*getenv();
BOOL		found();


main(argc, argv)
int argc;
char **argv;
{
	int	n;
	char	*p = getenv("PATH"), *q, path[256];

	if (argc != 2) {
		printf("Usage: %s command\n", argv[0]);
		exit(2);
	}

	if (p == NULL) {
		fprintf(stderr, "%s: No PATH environment.\n", argv[0]);
		exit(3);
	}

	if (*argv[1] == '/') {
		/* absolute path specified: no need to walk PATH */
		if (found(argv[1])) {
			puts(argv[1]);
			exit(0);
		}
		else	/* no such file found */
			exit(1);
	}

	/* walk through each path specified in the PATH environment,
	 * construct a path name and stat the file.
	 */
	q = p;
	n = strlen(p);

	while (n > 0) {
		while (*q != ':' && n-- > 0)
			q++;
		if (q != p)
			*q = '\0';

		sprintf(path, "%s/%s", p, argv[1]);

		if (found(path)) {
			puts(path);
			exit (0);
		}
		else /* not a valid path */
			p = q + 1;
	}
	exit(1);
}


BOOL
found(path)
char *path;
{
	struct stat 	stbuf;

	if (stat(path, &stbuf) < 0)
		return FALSE;

	if ((stbuf.st_mode & S_IFMT) == S_IFREG && stbuf.st_mode & S_IXUSR)
		return TRUE;

	return FALSE;
}
