/*
**
** vsar.c - visual sar for system status on System V
**
** This corresponds vaguely to the 'mon' program for 4.2
** It launches a sar and displays the output on the screen.
** Most display wierdness is attributable to sar, not vsar.
**
** Edit with 4 column tabs.
**
** Author:  David Brower
**          Relational Technology, Alameda, CA
**
**          {decvax, ucbvax}!mtxinu!rtech!daveb
**                                  rtech!gonzo!{daveb, root}
**
** This program is released to the public domain.
**
NEEDLIBS	=	CURSES
**
** Compile:
**		cc -O vsar.c -lcurses -o vsar
*/

# include	<stdio.h>
# include	<curses.h>
# include	<setjmp.h>
# include	<signal.h>
# include	<fcntl.h>

typedef struct
{
	short 	x, y;		/* x,y of message */
	short	skip;		/* leading amount to skip */
	short	doclear;	/* do clear to eol after? */
} MSG;

/* describe destiny of each header line from sar */
MSG hdrlines[] =
{
	/* blank */
	-1,	-1, 0,	0,

	/* node */			/* blank */			/* %usr */
	0,	0,	0,	1,		-1,	-1,	0,	0,		0,	43,	12,	0,

	/* paging */		/* runq */
	3,	0,	10,	1,		3,	32,	9,	0,

	/* text */
	6,	0,	9,	1,

	/* bread */			/* msgs */
	9,	0,	9,	1,		9,	63,	10,	1,

	/* scall */			/* igets */
	12,	0,	9,	1,		12,	56,	10,	0,

	/* mem */			/* swpin */
	15,	0,	9,	1,		15,	16,	9,	0,
	
	/* disks */
	18,	0,	10,	1,

	/* blank */
	-1,	-1,	0,	0
} ;


MSG datalines[] =
{
											/* %usr */
											1,	31,	0,	1,

	/* paging */		/* runq */
	4,	0,	10,	1,		4,	32,	9,	0,

	/* text */
	7,	0,	9,	1,

	/* bread */			/* msgs */
	10,	0,	9,	1,		10,	63,	10,	0,

	/* scall */			/* igets */
	13,	0,	9,	1,		13,	56,	10,	0,

	/* mem */			/* swpin */
	16,	0,	9,	1,		16,	16,	9,	0,
	
	/* disk(s) */
	19,	0,	10,	1,
	20,	0,	10,	1,
	21,	0,	10,	1,
	22,	0,	10,	1,
	23,	0,	10,	1,
	-1,	-1,	0,	0

} ;

/* cleanup terminal */
die()
{
	void	block();

	move( 20, 0 );
	refresh();
	endwin();
/*	resetty();	 */
	block();
	exit( 0 );
}


main( argc, argv )
int	argc;
char **argv;
{
	register MSG	* mp;
	register FILE	* sarfp;

	int		i;
	int		interval;

	char	buf[100];

	FILE	* popen();
	int		gotinput();
	void	noblock();

	/* process args */
	if( argc > 2 ) {
		fprintf( stderr, "Usage: %s [ interval ]\n", *argv );
		exit ( 1 );
	}
	
	interval = 5;
	if ( 2 == argc )
		(void) sscanf ( *++argv, "%d", &interval );

#ifdef notdef
	(void) sprintf( buf, "/usr/bin/sar -uamqvbcwd %d 9999", interval );
#else
	(void) sprintf( buf, "sar -upqvbmcarwd %d 99999", interval );
#endif
	(void) puts( buf );

	/* open the piped from sar */
	if ( NULL == (sarfp = popen( buf, "r" )) ) {
		perror("starting sar");
		exit ( 1 );
	}

	/* setup screen */
/*	savetty();	*/
	initscr();
	nonl();
	cbreak();
	noblock();

	/* make sure you cleanup */
	(void) signal( SIGINT, die );
	(void) signal( SIGQUIT, die );
	(void) signal( SIGTERM, die );
	(void) signal( SIGHUP, die );
	(void) signal( SIGSEGV, die );
	
	/* process header lines */
	for( i = 0; i < sizeof hdrlines / sizeof( MSG ); i++ ) {
		if ( NULL == fgets( buf, sizeof buf, sarfp ))
			die();

		domsg( buf, &hdrlines[i] );
	}

	/* process data lines forever */
	for( mp = datalines; ; mp++ ) {
		if ( gotinput() )
			clearok( curscr, TRUE );			

		if ( NULL == fgets( buf, sizeof buf, sarfp ))
			break;

		if ( '\n' == buf[0] ) {
			refresh();
			continue;
		}

		/* got a date?  Back to the top... */
		if( ' ' != buf[0] || mp->x == -1)
			mp = datalines;

		domsg( buf, mp );
	}

	die();
}


/* display a message */
domsg( buf, mp )
char * buf;
register MSG * mp;
{
	/* ignore this line */
	if ( -1 == mp->x )
		return;

	/* display in specified place */
	buf[ strlen( buf ) - 1 ] = '\0';
	move( mp->x, mp->y );
	addstr( &buf[ mp->skip ] );
	if ( mp->doclear )
		clrtoeol();

	/* always leave cursor here */
	move( 20, 0 );
}

/* put input in non-blocking state */
void
noblock()
{
	int	flags;

	flags = fcntl( 0, F_GETFL, 0 );
	(void) fcntl( 0, F_SETFL, flags | O_NDELAY );
}

/* put input in blocking state */
void
block()
{
	int	flags;

	flags = fcntl( 0, F_GETFL, 0 );
	(void) fcntl( 0, F_SETFL, flags & ~O_NDELAY );
}


/* any input pending? */
int
gotinput()
{
	char	garbage[ BUFSIZ ];

	/* return 0 if no input */
	return ( read( 0, garbage, sizeof garbage ) );
}



