:
#
# udf - display free disk space information in the BSD df(1)
#	output format.  This uses the System V df(1) to get
#	the actual data.
#
# Written by Ti Kan 3/2/90
#
# Usage: udf [-i] [filsys ...]
# The -i option makes udf display free inode information as well
#
# @(#)udf.sh	1.2	7/16/90 14:21:46

usage() {
    echo "Usage: $0 [-i] [filesys ...]"
    exit 1
}

PATH=/bin:/usr/bin:/etc; export PATH
FILSYS=
IFLAG=0

# Use the new awk if available
if [ -x /bin/nawk -o -x /usr/bin/nawk ]
then
    AWK=nawk
else
    AWK=awk
fi

# Parse command line arguments
set -- `getopt i $* 2>/dev/null`
if [ $? -ne 0 ]
then
    usage
fi

for i in $*
do
   case $i in
   -i)
	IFLAG=1
	shift
	;;
   --)
	shift
	FILSYS="$*"
	break
	;;
   esac
done

# Print banner
echo "Filesystem   kbytes    used   avail capacity \c"
if [ $IFLAG = "1" ]
then
    echo " iused   ifree  %iused \c"
fi
echo "Mounted on"


# Do real work of tranlating System V df output into BSD form
/bin/df -t $FILSYS | tr '(' ' ' | \
$AWK '{
    if ($1 != "total:") {
	mountpoint = $1
	fsnode = $2
	freeblocks = $4
	freeinodes = $6
    }
    else {
	totalblocks = $2
	totalinodes = $4
	usedblocks = totalblocks - freeblocks
	if (iflg == "1")
	    printf("%-11s%8d%8d%8d%6d%%%9d%8d%6d%%  %s\n",
		fsnode, totalblocks / 2, usedblocks / 2, freeblocks / 2,
		(totalblocks == 0) ? 0 : ((usedblocks * 100) / totalblocks),
		(totalinodes - freeinodes), freeinodes,
		(totalinodes == 0) ? \
		0 : (((totalinodes - freeinodes) * 100) / totalinodes),
		mountpoint)
	else
	    printf("%-11s%8d%8d%8d%6d%%   %s\n",
		fsnode, totalblocks / 2, usedblocks / 2, freeblocks / 2,
		(totalblocks == 0) ? 0 : ((usedblocks * 100) / totalblocks),
		mountpoint)
    }
}' iflg=$IFLAG
exit $?
