#ident "@(#)sioconf.h	2.1 90/08/15"
#ident "@(#) sioconf.h 22.1 89/10/25 "
/*
 *
 *	Copyright (C) The Santa Cruz Operation, 1985-1989.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 *
 */

typedef struct sio_device 
{
	char txbuffer;
	char intrenable;
	char intrident;
	char linctrlreg;
	char modemctrlreg;
	char linstatreg;
	char modemstatreg;
	char _xpadx;
} siodev_t;

#define rxbuffer	txbuffer
#define lsbdivlatch	txbuffer
#define msbdivlatch	intrenable
#define fifoctrlreg	intrident

typedef struct sio_device * sd;


typedef struct board {
	int b_num;	/* board number */
	int b_type;	/* each manufacturer gets a different one */
	int b_pcnt;	/* port count on the board */
	int b_vec;	/* interrupt vector */
	int b_dev;	/* minor dev base */
	sd  b_addr;	/* base address of board */
	int b_poll;	/* interrupt poll addr */
	int b_inc;	/* increment (spacing) of io ports on board */
	int b_outbits;	/* value for OUT1/OUT2 bits in MCR */
} board_t;

/* Modem Control Register defines */
#define MCRDTR		0x01    /* Data Terminal Ready */
#define MCRRTS		0x02    /* Request To Send */
#define MCRBIT2		0x04	
#define MCRBIT3		0x08	/* Interrupt control for 8250 level4 */

/* Board Number defines */
#define IBM_BOARD	0
#define HOST_BOARD	1
#define MITS_BOARD	2	/* mitsubishi (sperry) */
#define ARNET_BOARD	3
#define	AST_BOARD	4
#define	AMI_BOARD	5
#define	STARGATE	6
#define	DIGIBOARD	7
#define	KIMTRON		8
#define	QUADRAM		9
#define	CTC		10
#define TANDON		11
#define STARDUAL	12

/* stuff for kimtron board */
#define	KIMTRON_POLL	0x8000

/* stuff for ctc board */
#define	CTC_POLL	0x7

/* stuff for quadram board */
#define	QUADRAM0_POLL	0x2d3		/* Not a displacement */
#define	QUADRAM1_POLL	0x2db		/* Not a displacement */

/* stuff for hostess board */
#define	HOSTESS_POLL	0x7
#define	HOSTESS_MASK	0x7

/* stuff for mitsubishi (sperry) board */
#define MITS_POLL	0x40	/* displacement to poll register */
#define MITS_CNTRL	0x40
#define MITS_IR		0x01	/* interrupt reset bit (CNTRL reg) */
#define MITS_IE		0x02	/* interrupt enable bit (CNTRL reg) */

/* stuff for arnet board */
#define ARNET_POLL	0x42

/* stuff for AST board */
#define	AST_POLL	0x1f

/* stuff for AMI board */
#define	AMI0_POLL	0x210	/* NOT A DISPLACEMENT! com1 port at 0x210 */
#define	AMI1_POLL	0x212	/* NOT A DISPLACEMENT! com2 port at 0x220 */

/* stuff for stargate 4 and 8 port boards */
/* displacement to interrupt status port */
#define	STAR_POLL	0x40

/* stuff for tandon board */
#define TANDON0_BRD	0x2a0
#define	TANDON0_POLL	0x2a2		/* Not a displacement */
#define TANDON0_ECHO	0x680

#define TANDON1_BRD	0x280
#define	TANDON1_POLL	0x282		/* Not a displacement */
#define TANDON1_ECHO	0x6a0
