/*
 * Copyright(c) 1988 SecureWare, Inc.
 *	All Rights Reserved.
 * This Module contains Proprietary Information of SecureWare, Inc. and
 * should be treated as Confidential.
 */

							/* BEGIN   SCO_C2TCB */
#include "sys/param.h"
#include "sys/types.h"
#include "sys/dir.h"
#include "sys/signal.h"
#include "sys/security.h"
#include "sys/immu.h"
#include "sys/tss.h"
#include "sys/page.h"
#include "sys/region.h"
#include "sys/fstyp.h"
#include "sys/fs/s5inode.h"
#ifdef B1
#include "sys/mount.h"
#include "sys/nami.h"
#include "sys/statfs.h"
#include "sys/ino.h"
#include "sys/fs/s5filsys.h"
#include "sys/buf.h"
#endif
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/proc.h"
#include "sys/file.h"
#include "sys/inode.h"
#include "sys/ipc.h"



extern int icode[];
extern int szicode;

extern int nodev();


/*
 * From auditing sources:
 */
audstub_open1()
{
}

audstub_open2()
{
}

audstub_ipc1()
{
}

audstub_ipc2()
{
}

audstub_ipc3()
{
}

audstub_ipc4()
{
}

audstub_ipc5()
{
}

#ifdef M_XENIX
audstub_ipc6()
{
}

audstub_ipc7()
{
}
#endif

audstub_fcntl1()
{
}

audstub_rdwr1()
{
}

audstub_close1()
{
}

audstub_dac1()
{
}

audstub_dac2()
{
}

audstub_exit1()
{
}

audit()
{
}

char *
audit_execpath()
{
	return((char *) 0);
}

audit_setup()
{
}

#ifdef M_XENIX
audit_setup1()
{
}

audit_setup2()
{
}
#endif

audit_maskdup()
{
}

audinit()
{
}

audopen()
{
	(void) nodev();
}

audclose()
{
	(void) nodev();
}

audread()
{
	(void) nodev();
}

audwrite()
{
	(void) nodev();
}

audioctl()
{
	(void) nodev();
}

/*
 * From sec_subrs.c:
 */
void
sec_init()
{
}

void
sec_move_initial_code()
{
	copyout((caddr_t) icode, (caddr_t) 0, szicode);
}

int
sec_size_initial_code()
{
	return szicode;
}

int
sec_core_mode()
{
	return 0666;
}

int
exec_allowed()
{
	return 1;
}

int
pass_dir_protection(ip, pp, uid)
	struct inode *ip;
	struct inode *pp;
	short uid;
{
	return 1;
}

int
io_allowed(fp, p)
	struct file *fp;
	struct proc *p;
{
	return 1;
}

int
issetluid()
{
	return 1;
}

void
update_modes(ip)
	struct inode *ip;
{
}

int
sec_mode_change_permitted(new_mode)
	long new_mode;
{
	return 1;
}

int
sec_owner_change_permitted(old_owner, old_group, new_owner, new_group)
	ushort old_owner;
	ushort old_group;
	ushort new_owner;
	ushort new_group;
{
	return 1;
}

void
privs_copy(cp, pp)
	struct proc *cp;
	struct proc *pp;
{
}

int
s5security(ip, cmd, argp)
	register struct inode *ip;
	int cmd;
	char *argp;
{
	return 0;
}

int
privileged(privilege, error_code)
	int privilege;
	int error_code;
{
	if (error_code == 0)
		return (u.u_uid == 0);
	else
		return suser();
}

/*
 * From sec_prmain.c:
 */
void
promain_copy()
{
}

void
exit_promain()
{
}

int
promain_ipcaccess(p, mode)
	register struct ipc_perm *p;
	register ushort mode;
{
	if(u.u_uid == 0)
		return(0);
	if(u.u_uid != p->uid && u.u_uid != p->cuid) {
		mode >>= 3;
		if(u.u_gid != p->gid && u.u_gid != p->cgid)
			mode >>= 3;
	}
	if(mode & p->mode)
		return(0);
	u.u_error = EACCES;
	return(1);
}

int
file_access(ip, m)
	register struct inode *ip;
	register int m;
{
	register struct s5inode *s5ip;

	s5ip = (struct s5inode *) ip->i_fsptr;
	if (u.u_uid == 0)
		return(0);
	if (u.u_uid != ip->i_uid) {
		m >>= 3;
		if (u.u_gid != ip->i_gid)
			m >>= 3;
	}
	if ((s5ip->s5i_mode & m) != 0)
		return(0);

	u.u_error = EACCES;
	return(1);
}

int
promain_determine_ownership(uid)
	ushort uid;
{
	return (u.u_uid == uid || suser());
}

void
create_promain(ip)
	struct inode *ip;
{
}

void
set_dir_location(dp)
	struct inode *dp;
{
}

void
check_enter_promain_hierarchy(dp)
	struct inode *dp;
{
}

void
check_exit_promain_hierarchy(dp)
	struct inode *dp;
{
}

void
promain_placement(ipp)
	struct inode **ipp;
{
}

int
promain_in()
{
	return 1;
}

int
promain_file_link(in, ip)
	int in;
	struct inode *ip;
{
	return 1;
}


/*
 * From sec_calls.c:
 */
int
security()
{
	nosys();
}


#ifdef B1
/*
 * From sec_b1.c:
 */
int
privileged_fork()
{
	return !(u.u_uid && u.u_ruid);
}

void
compute_subject_privileges(ip)
	struct inode *ip;
{
}

int
sec_newpid(max_pid, prev_pid)
	int max_pid;
	int prev_pid;
{
	register int new_pid;

	new_pid = prev_pid + 1;

	if (new_pid >= max_pid)
		new_pid = 1;

	return new_pid;
}

void
sec_ipc_slot(slots, new_entry, slot_size, slot_max)
	struct ipc_perm *slots;
	struct ipc_perm **new_entry;
	int slot_size;
	int slot_max;
{
	register int slot_scan;
	register struct ipc_perm *pslot;
	register int found;

	pslot = slots;
	found = 0;
	for (slot_scan = 0; !found && (slot_scan < slot_max); slot_scan++)  {
		if ((pslot->mode & IPC_ALLOC) == 0)
			found = 1;
		else
			pslot = (struct ipc_perm *) (((char *) pslot) +
						     slot_size);
	}

	if (found)
		*new_entry = pslot;
	else
		*new_entry = (struct ipc_perm *) 0;
}

int
sec_can_create_dir(ip, p)
	register struct inode *ip;
	struct nx *p;
{
	return s5access(ip, IWRITE) == 0;
}

void
sec_mount_prelim(mount_entry, initial_setup)
	register struct mount *mount_entry;
	int initial_setup;
{
}

int
evaluate_fstype(mount_entry, blk_dev, attrs, call_point)
	struct mount *mount_entry;
	struct inode *blk_dev;
	attr_t *attrs;
	int call_point;
{
	struct filsys *fp;


	fp = getfs(mount_entry);

	switch (fp->s_type)  {
		case Fs1b|FsSW:
		case Fs2b|FsSW:
			switch (call_point)  {
				case 0:
#ifdef u3b2
					u.u_error = EINVAL;
					return 0;
#else
					mount_entry->m_bsize = 512;
#endif
					break;
				case 1:
					mount_entry->m_bsize = 512;
					break;
			}
			break;
	}

	return 1;
}

void
sec_reset_file_system(mount_entry, blk_dev)
	register struct mount *mount_entry;
	struct inode *blk_dev;
{
}

int
sec_valid_filesystem(fp, sp)
	register struct filsys *fp;
	register struct statfs *sp;
{
	if (fp->s_type == Fs2b) {
		sp->f_bsize = 1024;
	} else if (fp->s_type == Fs1b) {
		sp->f_bsize = 512;
	} else {
		u.u_error = EINVAL;
		return 0;
	}

	return 1;
}

void
sec_s5iextendedalloc(ip)
	register struct inode *ip;
{
}

int
sec_s5iextendedread(dp, ip, bp)
	register struct dinode *dp;
	register struct inode *ip;
	struct buf *bp;
{
	return 1;
}

void
sec_s5iextendedwrite(dp, ip)
	register struct dinode *dp;
	register struct inode *ip;
{
}

void
sec_add_disk_ino(dp, mount_entry, incr)
	register struct dinode **dp;
	register struct mount mount_entry;
	int incr;
{
	((struct insec_dinode *)(*dp)) += incr;
}

int
sec_FsINOPB(mount_entry)
	struct mount *mount_entry;
{
	return FsINOPB(mount_entry->m_bsize);
}


int
sec_INOSHIFT(inopb)
	int inopb;
{
	return INOSHIFT;
}


daddr_t
sec_FsITOD(mount_entry, inode_number)
	struct mount *mount_entry;
	int inode_number;
{
	return FsITOD(mount_entry->m_bsize, inode_number);
}


daddr_t
sec_FsITOO(mount_entry, inode_number)
	struct mount *mount_entry;
	int inode_number;
{
	return FsITOO(mount_entry->m_bsize, inode_number);
}


daddr_t
sec_FsINOS(mount_entry, inode_number)
	struct mount *mount_entry;
	int inode_number;
{
	return FsITOO(mount_entry->m_bsize, inode_number);
}


/*
 * From sec_mld.c:
 */
int
mld(ip)
	struct inode *ip;
{
	return 0;
}

void
mld_op_init(namei_xfer)
	struct nx *namei_xfer;
{
}

void
mld_op_set(namei_xfer)
	struct nx *namei_xfer;
{
	namei_xfer->flags = 0;
}

int
mld_op(namei_xfer)
	struct nx *namei_xfer;
{
	return 0;
}

void
mld_set_identity(ip, namei_cmd, namei_xfer)
	struct inode *ip;
	struct argnamei *namei_cmd;
	struct nx *namei_xfer;
{
}

int
mld_op_clear(namei_xfer)
	struct nx *namei_xfer;
{
	return 0;
}

int
mld_traverse(ip, p_old_component, divert, namei_cmd, namei_xfer)
	register struct inode *ip;
	caddr_t *p_old_component;
	register struct argnamei *divert;
	struct argnamei **namei_cmd;
	struct nx *namei_xfer;
{
	return SEC_MLD_PASS;
}

#endif
#endif
							/* END     SCO_C2TCB */
