/*
 *	@(#) bkp.h 22.1 90/03/30 
 *
 *	Copyright (C) The Santa Cruz Operation, 1984-1988, 1989, 1990.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, and should be treated as Confidential.
 */

/*
*	MODIFICATION HISTORY:
*
*	S000	sco!natei	Fri Mar 30 10:48:37 PST 1990
*		- Insertion into kernel build tree
*/

#define		BPNL	31
#define		NLPBP	8

struct bkp {
	long		bp_seg;
	long		bp_off;
	unsigned char	bp_svopcode;
	char		bp_name[BPNL];
	struct ilin	*bp_cmds[NLPBP];
};

#define		FOUND_NOTFOUND	0	/* sounds stupid */
#define		FOUND_USERQ	1
#define		FOUND_BP	2
#define		FOUND_DBP	3
/*
 *	@(#) dvar.h 22.1 90/03/30 
 *
 *	Copyright (C) The Santa Cruz Operation, 1984-1988, 1989, 1990.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, and should be treated as Confidential.
 */

/*
*	MODIFICATION HISTORY:
*
*	S000	sco!natei	Fri Mar 30 10:48:37 PST 1990
*		- Insertion into kernel build tree
*/

#define	DVNL	16	/* name length of variable	*/

/*
*	no reasonable person will need a variable to remember the
*	value 0, so use 0 to clear the variable.
*/
struct dbvar {
	long	dv_val;
	char	dv_name[DVNL];
};
/*
 *	@(#) histedit.h 22.1 90/03/30 
 *
 *	Copyright (C) The Santa Cruz Operation, 1984-1988, 1989, 1990.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, and should be treated as Confidential.
 */

/*
*	MODIFICATION HISTORY:
*
*	S000	sco!natei	Fri Mar 30 10:48:37 PST 1990
*		- Insertion into kernel build tree
*/

#define		DBIBFL		128	/* input buf length */
#define		DBNARG		16	/* # args to break up input */

#define		CTRL(c)		(c - 'A' + 1)

/*
*	in space.c:
*/
extern char	*c_move_up;
extern char	*c_move_down;
extern char	*c_move_right;
extern char	*c_move_left;
extern char	*c_delete_line;
extern char	*c_delete_char;
extern char	*c_insert_char;
extern char	*c_insert_line;
extern char	*c_clear_to_eol;

#define		up()		printf(c_move_up)
#define		down()		printf(c_move_down)
#define		right()		printf(c_move_right)
#define		delch()		printf(c_delete_char)
#define		delline()	printf(c_delete_line)
#define		insch()		printf(c_insert_char)
#define		insline()	printf(c_insert_line)
#define		clrtoeol()	printf(c_clear_to_eol)
#define		backsp()	printf(c_move_left)

#define		goloc(n)					\
			{					\
				putchar('\r');			\
				for (i = -(n);i < prlen;i++)	\
					right();		\
			}


/*
*	buffers are circular
*/
struct ilin {
	int	il_narg;
	char	il_ibuf[DBIBFL];
	char	*il_ivec[DBNARG];
};

#define		freebuf(il)	((il)->il_narg = 0)

#define		MXLIBUF		128
#define		MXPRL		32
#define		ntob(l, n)	((n) % (l)->li_mod)
#define		dtoc(n)		((n) + '0')

#define		LF_CANERR	0x00000001
#define		LF_WRAPS	0x00000002
#define		LF_EDITING	0x00000004
#define			LF	0x0000000F
#define		LF_PLN		0x0000FFF0
#define			LFPLS	4
#define		LF_PLX(l,n)	((l)->li_flag |= (((n) << LFPLS) & LF_PLN))
#define		LF_PL(l)	(((l)->li_flag & LF_PLN) >> LFPLS)

#define		prlen		(list->li_pp - list->li_prompt)

#define		LB_SAVED	0x01
#define		LB_SEARCHED	0x02
struct lsbu {
	int		lb_flag;
	int		lb_hc;
	int		lb_vc;
	int		lb_nc;
	char		lb_save[DBIBFL];
	char		lb_search[DBIBFL];
};

struct list {
	int		li_flag;
	int		li_rflag;
	int		li_mod;
	int		li_minum;
	int		li_mxnum;
	int		li_curnum;	/* current line number */
	char		li_prompt[MXPRL];
	char		*li_pp;
	struct lsbu	li_lsbuf;
	struct ilin	*li_buffers[1];
};

/*				      FFFF	taken by LF_*	*/
#define		ED_CANCEL	0x00000000
#define		ED_OK		0x00010000
#define		ED_EDIT		0x00020000
#define			ED	0x00070000

#define		OP_GL		0x00080000
#define		OP_DL		0x00100000
#define		OP_AL		0x00200000
#define		OP_CO		0x00400000
#define		OP_RT		0x00500000	/* return */
#define		OP_SR		0x00800000
#define		OP_SF		0x00900000	/* SR forw */
#define			OP	0x00F80000

#define		OP__LN		0xFF000000
#define		OP__LS		24		/* - enough?	*/
#define			LN(x)	(((x) & OP__LN) >> OP__LS)
#define			LS(n)	((n) << OP__LS)
/*
 *	@(#) structs.h 22.1 90/03/30 
 *
 *	Copyright (C) The Santa Cruz Operation, 1984-1988, 1989, 1990.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, and should be treated as Confidential.
 */

/*
*	MODIFICATION HISTORY:
*
*	S000	sco!natei	Fri Mar 30 10:48:37 PST 1990
*		- Insertion into kernel build tree
*/

#define		STUNF		"stun.def"	/* default output */
#define		STRFPROTO	"strfproto"

#define		TMPLT		"/tmp/stunXXXXXX"

#define		MXFIL	1024	/* max files to give to structs */
#define		MXARG	64	/* max args to it */

#ifndef NAMEL
# define		NAMEL		32
#endif
#define		NMEL(ar)	(sizeof(ar)/sizeof((ar)[0]))
#define		whites(s)	while (isspace(*(s))) ++(s)

/*
*	st_flags
*/
#define		SUF_STRUCT	001
#define		SUF_UNION	002
#define		SUF_FAKE	004
#define		SUF_ALIAS	010	/* is an alias */
#define		SUF_HALIAS	020	/* has an alias */

#define		DB_NOMEM	0x01
#define		DB_MALLOC	0x02
#define		DB_FAIL		0x04
#define		DB_EACHFILE	0x08
#define		DB_SPAWN	0x10
#define		DB_REPORT	0x20
#define		DB_DUMP		0x40
#define		DB_ALIAS	0x80
#define	DB_ALL	0xFF

/*
*	each line, as it is read in
*/
struct line {
	char	l_def[NAMEL];
	char	l_val[NAMEL];
	char	l_scl;
	short	l_type;
	int	l_dim;
	int	l_size;
	char	l_tag[NAMEL];
	char	l_endef;
};

#define		EOS(l)	((l)->l_scl == C_EOS)


#ifndef NULL
# define	NULL		(0)
#endif

#define		SNF_FIELD	01	/* stunel is bit field */
struct stunel {
	char		sn_flags;
	char		*sn_name;
	long		sn_type;
	int		sn_val;
	int		sn_size;
	char		*sn_tag;
	struct stun	*sn_link;
	struct stunel	*sn_next;
	struct stunel	*sn_last;
};

/*
*	structs and unions
*
*	if (st_flags & SUF_ALIAS)
*		then st_alias points to the stun that holds the
*		     real info (for typedefs).
*/
struct stun {
	char		*st_name;
	short		st_flags;
	short		st_size;
	short		st_nmel;
	struct stunel	*st_head;
	struct stunel	*st_tail;
	struct stun	*st_next;
	struct stun	*st_last;
	int		st_index;
	struct stun	*st_alias;
};






/*************************************************************
*
*	OUTPUT TO STUNDEF FILE: also in-core format
*/


/*
*	structure of output file:
*
*	int nstun		number of structures
*	struct stp stpar[nstun]
*	cstun 1
*	cstel 1a
*	cstel 1b
*	...
*	cstun 2
*	cstel 2a
*	...
*	...
*	...
*	cstun (nstun-1)
*	cstel (nstun-1)a
*	...
*/

/*
*	in-core name length; watch the length - this hogs space
*/
#define		CNAML		10

/*
*	the high bit of the sp_offset is used to denote an aliased
*	stun, since there is no cstun for it.
*/
#define		S_ALIAS		0x80000000

struct stp {
	char	sp_name[CNAML];	/* name of structure */
	int	sp_offset; /* offsets are relative to first cstun */
};
	

/*
*	in-core struct/union element
*/
struct cstel {
	short		ce_flags;
	long		ce_type;
	char		ce_name[CNAML];
	short		ce_offset;	/* into structure */
	short		ce_size;	/* of field */
	int		ce_index;
};

/*
*	in-core, an array of pointers to the following structure
*	is kept, one per structure/union definition
*/
struct cstun {
	short		cs_flag;
	short		cs_size;	/* st/un size */
	short		cs_nmel;	/* number of cstel to follow */
};

#define		SSTNAMEL	16

struct sstun {
	long	ss_addr;
#ifndef SPACE_C
	union {
		struct {
			int	ssuc_zeroes;
			int	ssuc_stp;
# define ss_zeroes	ss_u.ssu_stp.ssuc_zeroes
# define ss_stp		ss_u.ssu_stp.ssuc_stp
		} ssu_stp;
#endif
		char ssu_name[SSTNAMEL];
# define ss_name	ss_u.ssu_name
#ifndef SPACE_C
	}	ss_u;
#endif
};
/*
 *	@(#) alias.h 22.2 90/04/02 
 *
 *	Copyright (C) The Santa Cruz Operation, 1984-1988, 1989, 1990.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, and should be treated as Confidential.
 */

/*
*	MODIFICATION HISTORY:
*
*	S000	sco!natei	Fri Mar 30 10:48:37 PST 1990
*		- Insertion into kernel build tree
*
*	S001	sco!natei	Mon Apr  2 16:36:04 PDT 1990
*		- s/CWORD/SUBARG , added NOALIAS
*/

#define		ALIASLOOP	10
#define		SUBARG		'!'	/* S001 */
#define		NOALIAS		'/'	/* S001 */

#define		ALNAMEL		16

struct alias {
	char	 al_name[ALNAMEL];
	char	*al_vec[DBNARG];
	char	 al_buf[DBIBFL];
};
