#ident "@(#)space.c	1.12 91/07/12"
#ident "@(#) space.c 22.7 90/03/19 "

/*
 *   Portions Copyright 1983-1989 The Santa Cruz Operation, Inc
 *		      All Rights Reserved
 */
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */

#define BUFDEFINE
#include "sys/types.h"
#include "sys/param.h"
#include "sys/buf.h"
#include "sys/immu.h"
#include "sys/region.h"
#include "sys/map.h"
#include "sys/signal.h"
#include "sys/proc.h"
#include "sys/inode.h"
#include "sys/fs/s5inode.h"
#include "sys/fs/s5param.h"
#include "sys/file.h"
#include "sys/callo.h"
#include "sys/var.h"
#include "sys/mount.h"
#include "sys/swap.h"
#include "sys/tuneable.h"
#include "sys/fcntl.h"
#include "sys/flock.h"
#include "sys/sysinfo.h"
#include "sys/tty.h"
#include "sys/conf.h"
#include "sys/utsname.h"
#include "sys/sema.h"
#include "sys/acct.h"
#include "sys/pfdat.h"
#include "sys/weitek.h"
#include "sys/stream.h"
#include "sys/sysmacros.h"
#include "sys/emap.h"		/* channel mapping include file from XENIX */
#include "sys/nmap.h"		/* channel mapping include file from XENIX */
#include "sys/dio.h"
#include "sys/disk.h"
#include "sys/scsi.h"

#define SYS	"unix"
#define REL	"3.2"
#define VER	"2"
#define MACH	"i386"
#define XMACH	"i80386"

#define RESRVD	""
#define ORIGIN	1
#define OEMNUM	0
#define SERIAL	0

#define SCORELEASE	"3.2v2.0"
#ifdef MC386
#define BUS		"MC"
#else
#define BUS		"AT"
#endif

int eisa = 0;		/* 0: AT    1: EISA */

#include "config.h"	/* to collect all other tunable parameters */

/*
 * Tables and initializations
 */

extern	int	oeminit(),
		cinit(),
		binit(),
		inoinit(),
		fsinit(),
		finit(),
		iinit(),
		flckinit(),
		seminit(),
		msginit(),
		strinit(),
		xsdinit(),
		xseminit();	
int	(*init_tbl[])() = {
		oeminit,
	  	cinit,
	  	binit,
	  	inoinit,
	  	fsinit,
	  	finit,
	  	iinit,
	  	flckinit,
		seminit,
		msginit,
	  	strinit,
		xsdinit,
		xseminit,
	  	0,
};

struct	buf	*pbuf;
struct	hbuf	hbuf[NHBUF];
struct	file	file[NFILE];
struct	inode	inode[NINODE];
time_t	inoblkltm[NINODE];
struct	s5inode	s5inode[NS5INODE];
struct	proc	proc[NPROC];
struct	region	region[NREGION];
struct	callo	callout[NCALL];
struct	mount	mount[NMOUNT];
struct	map	sptmap[SPTMAP];
struct	map	piomap[PIOMAP];
struct	emap	emap[NEMAP];		/* channel mapping data struct table */
struct	nmap	nmap[NEMAP];		/* channel mapping data struct table */
struct  diskinfo diskinfo[NDISK];
int	piomapsz = PIOMAP;
int piomaxsz = PIOMAXSZ;
char		putbuf[PUTBUFSZ];
int		putbufsz = PUTBUFSZ;

int		nmphbuf;

/* 16M+ memory parameters */
int	non_dma_present;		/* Non-DMAable memory present flag */
int	dmaable_pages = DMAABLEBUF;	/* DMAable pages in pool list      */
int	dmaable_free = DMAABLEBUF;	/* Current free pages in pool list */
char   *dmaable_anchor;			/* ptr to head of page pool list   */
int	dmaable_sleep = 0;
int	dmaable_total;

struct pfdat *first_dmaable;		/* First DMAable pfdat 		   */
struct pfdat *last_dmaable;		/* Last DMAable pfdat 		   */
struct pfdat *scan_dmaable;		/* Current pfdat scan ptr	   */

struct	var	v = {
		NBUF,
		NCALL,
		NINODE,
		(char *)(&inode[NINODE]),
		NFILE,
		(char *)(&file[NFILE]),
		NMOUNT,
		(char *)(&mount[NMOUNT]),
		NPROC,
		(char *)(&proc[NPROC]),
		NREGION,
		NCLIST,
		MAXUP,
		NHBUF,
		NHBUF-1,
		NPBUF,
		SPTMAP,
		VHNDFRAC,
		MAXPMEM,
		NAUTOUP,
		NOFILES,
		NQUEUE,
		NSTREAM,
		NBLK4096,
		NBLK2048,
		NBLK1024,
		NBLK512,
		NBLK256,
		NBLK128,
		NBLK64,
		NBLK16,
		NBLK4,
		NS5INODE,
		ULIMIT,
		NSCRN,
		NEMAP,
		NUMSXT,
		XSDSEGS,
		XSDSLOTS,
		SCRNMEM,
		KBTYPE,
		NDISK,
		EVQUEUES,
		EVDEVS,
		EVDEVSPERQ,
		MAXBUF,
		NGROUPS,		/* New for POSIX  */
#ifdef FFS
		BFREEMIN,	/* v_bfreemin */
		NMPBUF,		/* v_mpbuf */
		NMPHEADBUF,	/* v_mpheadbuf */
#endif
		S5CACHEENTS,    /* v_s5cacheents */
		S5HASHQS,	/* v_s5hashqs	 */
		S5OFBIAS,	/* v_s5ofbias    */
};

struct	tune	tune = {
		GPGSLO,
		GPGSHI,
		GPGSMSK,
		0,
		AGEINTERVAL,
		MAXSC,
		MAXFC,
		MAXUMEM,
		BDFLUSHR,
		MINARMEM,
		MINASMEM,
		MAXVD,
		CACHESYSBUF,
                NSGLIST,
		NRIOBUF,
		HDBACKTRACK
};
int	Dstflag = DSTFLAG;	/* tuneable daylight time flag for XENIX */
int	Timezone = TIMEZONE;	/* tuneable time zone for XENIX ftime() */
int	dma_single = DMAEXCL;
int	ename_trunc = ETRUNC;	/* parm to allow truncation of long filenames */
int	Hz = HZ;
int	Cmask = CMASK;


struct scsi_sg_list sglist[NSGLIST]; /* scatter/gather list for raw I/O */
int	lockd_single;
int	(*reclock_fn)();
int	(*cleanlocks_fn)();
struct	flckinfo flckinfo = {FLCKREC};
struct	filock 	 flox[FLCKREC];
struct	shlbinfo	shlbinfo = {SHLBMAX, 0, 0};
struct	utsname	utsname = {
		SYS,
		NODE,
		REL,
		VER,
		MACH
};

struct	xutsname xutsname = {
		SYS,
		NODE,
		REL,
		VER,
		XMACH,
		RESRVD,
		ORIGIN,
		OEMNUM,
		SERIAL
};

struct scoutsname scoutsname = {
		SYS,		/* ie. "machine name" */
		NODE,		/* ie. "site name" */
		SCORELEASE,	/* The release number */
		"",		/* kernel id, filled in at runtime */
		XMACH,		/* The full chip name */
		BUS,		/* GT vs. MC */
		"",		/* SCO serial number */
		ORIGIN,		/*  */
		OEMNUM,		/*  */ 
		"",		/* Number of users Licensed */
		1,		/* Number of CPUs */
		""		/* Altos Version number */
};

/* Line Discipline Switch Table
 * order: open close read write ioctl rxint txint modemint
 */
extern int 	nulldev();
extern int 	ttopen(),
		ttclose(),
		ttread(),
		ttwrite(),
		ttioctl(),
		ttin(),
		ttout(),
		sxtin(),
		sxtout(),
		moopen(),
		moclose(),
		moread(),
		moioctl(),
		moin();

struct	linesw	linesw[] = {
/* 	tty ------------- */
			 ttopen,
			 ttclose,
			 ttread,
			 ttwrite,
			 ttioctl,
			 ttin,
			 ttout,
			 nulldev,
/*	sxt ------------- */
			 nulldev,
			 nulldev,
			 nulldev,
			 nulldev,
			 nulldev,
			 sxtin,
			 sxtout,
			 nulldev,
/*	evld ------------ */
			 moopen,
			 moclose,
			 moread,
			 ttwrite,
			 moioctl,
			 moin,
			 ttout,
			 nulldev,
 };
int     linecnt=3;

/* DU */
int		remote_acct;		/* REMOTE flag for acctp */
int		bootstate;		/* DU boot flag */
short		dufstyp;		/* DU file system switch index */
struct	srmnt	srmount[NSRMOUNT];
int		nsrmount  = {NSRMOUNT};
int		nservers  = {0};
int		idleserver  = {0};
int		msglistcnt  = {0};
struct	dinfo	dinfo;			/* DU perf stat's */

struct	acct	acctbuf;
struct	inode	*acctp;
struct	buf	*sbuf;		/* Start of buffer headers	    */
struct	buf	bfreelist;	/* Head of the free list of buffers */
struct	pfree	pfreelist;	/* Head of physio buffer headers    */
int		pfreecnt;	/* Count of free physio buffers.    */
struct scsi_io_req riofreelist; /* Head of the REQ IO list of bufers */
struct inode	*rootdir;	/* Inode for root directory. */

int	nptalloced;	/* Total number of page tables allocated.	*/
int	nptfree;	/* Number of free page tables.			*/

reg_t	ractive;
reg_t	rfree;
reg_t	sysreg;

proc_t	*runq;		/* Head of linked list of running procs. */
proc_t	*curproc;	/* The currently running proc.		 */
proc_t	*old_curproc;	/* Previous curproc */
proc_t	*oldproc;	/* The previous proc, if it exited.	 */
int	curpri;		/* Priority of currently running proc.	 */

struct pfdat	phead;		/* Head of free page list. */
struct pfdat	*pfdat;		/* Page frame database. */
struct pfdat	**phash;	/* Page hash access to pfdat. */
struct pfdat	ptfree;		/* Head of page table free list. */
struct pfdat	dbdfree;	/* Head of DBD table free list. */
int		phashmask;	/* Page hash mask. */

struct sysinfo sysinfo;
struct	syswait	syswait;
struct	syserr	syserr;
struct	rcinfo	rcinfo;		/* DU perf stat's */
struct  minfo minfo;

#include	"sys/fs/s5macros.h"
#include	"sys/rbuf.h"

/* parameters for remote (RFS) network access (which uses buffers from 
 * local buffer pool) */
struct rbuf rbfreelist;
unsigned long lbuf_ct;
unsigned long rbuf_ct;
unsigned long nrbuf;
unsigned long nlbuf;
unsigned long maxbufage = 0;
int	rcache_enable = 0;
int	rcacheinit = 0;		/* RFS client caching initialized*/
unsigned long rfs_vcode = 1;	/* version code for RFS caching */

swpt_t	swaptab[MSFILES];
int	nextswap;
daddr_t swplo = 0;
daddr_t nswap;  /* set by disk driver when mounting root fs to size of swap */


/*	Each process has 3 pregions (text, data, and stack) plus
 *	enough for the maximum number of shared memory segments.
 *	We also need one extra null pregion to indicate the end
 *	of the list.  The maximum number of shared memory segments
 *	will be added in reginit.
 */

int	pregpp = 3 + 1;


/*	The following describe the physical memory configuration.
**
**		maxclick - The largest physical click number.
**			   ctob(maxclick) is the largest physical
**			   address configured plus 1.
**
**		physmem	 - The amount of physical memory configured
**			   in clicks.  ctob(maxclick) is the amount
**			   of physical memory in bytes.
**		kpbase	 - The physical address of the start of
**			   the allocatable memory area.  That is,
**			   after all kernel tables are allocated.
**			   Pfdat table entries are allocated for
**			   physical memory starting at this address.
**			   It is always on a page boundary.
*/

int	maxclick;
int	physmem;
paddr_t	kpbase;


/*	The following are concerned with the kernel virtual
**	address space.
**
**		kptbl	  - The address of the kernel page table.
**			    It is dynamically allocated in startup.c
**		userpt	  - Points to the page table for the u block.
**			    Mapped by win_ublk.
**		piownptbl - Points to the page table for the pio windows.
**			    It is dynamically allocated in startup.c
**		usertable - The address of the page table used to map
**			    the current u block.
*/

pde_t	*kptbl;
pde_t	*userpt;
pde_t	*piownptbl;
pde_t	*usertable;

/*	The following space is concerned with the configuration of
**	NOFILES.  We have to do it this hard way because the code
**	which actually does this is in the assembly language file
**	misc.s and can't include header files or conveniently
**	print things.
**
**	The variable nofiles_cfg is assigned a value here to force
**	it to be in the data region rather than bss.  The value
**	will be overwritten by the code at vstart_s in misc.s.
**	However, this occurs before bss is cleared so that if
**	this variable were in bss, the value written by vstart_s
**	would be cleared in mlsetup when bss is cleared.
*/

int	nofiles_min = NOFILES_MIN;
int	nofiles_max = NOFILES_MAX;
int	nofiles_cfg = 1;		/* Originally configured value. */

char	fp_kind;
int	do387cr3 = DO387CR3;
/*	The following describe the minimum conditions required
**	for putting the stack below data and starting it in
**	the data region's page table.
*/
int minhidustk = ctob(MINHIDUSTK);
int minustkgap = ctob(stoc(MINUSTKGAP));

/*	The following are used for conditional debugging.	*/

#include "sys/xdebug.h"
char bugbits[NDBC] = {
	0,	/* Exec system call */
	0,	/* Floating Point */
	0,	/* System initialization */
	0,	/* Memory allocation */
	0,	/* memory management */
	0,	/* raw I/O */
	0,	/* Signals */
	0,	/* Process switching */
	0,	/* Text table management */
	0,	/* Traps and faults */
	0,	/* Page faults */
	0,	/* Pageout */
	0,	/* Scall */
	0, 	/* filesystem page cache */
	0, 	/* copy on write fork */
	0, 	/* swapping */
	0, 	/* ipc msgs, sems, shm */
	0,	/* console */
	0,	/* disk driver */
	0,	/* page sync */
	0,	/* context switch */
	0,	/* dma */
};

char entryfmt[] = "Entering %s\n";
char exitfmt[] = "Leaving %s\n";

int
strcmp(s1, s2)
char *s1, *s2;
{
	return( kstrcmp(s1, s2) );
}
