#ident "@(#) space.c 21.1 89/12/06 "
/*
 *	Copyright (C) The Santa Cruz Operation, 1985, 1986, 1987, 1988.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 */

/*
 *	Configurable parameters for the (QIC-02) Cartridge Tape driver
 *
 *	If parameter is not initialized, the default for the type of
 *	machine will be used. The dma channel and interrupt vector
 *	will override the defaults if initialized. The default base
 *	address will override the configurable parameter providing
 *	the default works. 
 *
 *	Defaults for Type A:
 *		ctdmach = 3, ctint = 3, ctbase = 0x220
 *			-or-
 *		ctdmach = 1, ctint = 4, ctbase = 0x200
 *
 *	Defaults for Type W:
 *		ctdmach = 1, ctint = 5, ctbase = 0x338
 *
 *	Defaults for Type E:
 *		ctdmach = 3, ctint = 25, ctbase = 0x29C
 *
 *	Defaults for Type M:
 *		ctdmach = 1, ctint = 3, ctbase = 0x28C
 *
 *	Defaults for Type T:
 *		ctdmach = 1, ctint = 5, ctbase = 0x330
 *
 *	Defaults for Type X:
 *		ctdmach = 1, ctint = 3, ctbase = 0x2C0
 *
 */
#include "config.h"

#define	CTCNTRLR	0	/* @PARM1 */
#define	CTDMACH		0	/* @PARM2 */
#define	CTINT		0	/* @PARM3 */
#define	CTBASE		0x0	/* @PARM4 */

short ctcntrlr	= CTCNTRLR;	/* controller type (0=auto,1=A,3=W,4=E) */
short ctdmach	= CTDMACH;	/* dma channel (must be 1 or 3) */
short ctint 	= CTINT;	/* LOGICAL interrupt vector number */
short ctbase 	= CTBASE;	/* 4 i/o addresses used from here up */
int Ctbufsize	= CTBUFSIZE*1024;
unsigned char	*Ctbuf = 0;
