/*	biparms.h 6.1 of 8/22/83
	@(#)biparms.h	6.1		*/

/*
	This file defines the mnemonics that are common to both the
	bisync vpm script and the synchronous terminal top driver.

	This file is #included in the ratfor script compilation as 
	well as the c-language driver compilation


**************************************************************************

	UNSOLICITED (TRACE) MESSAGES PASSED FROM THE SCRIPT TO
		THE SYNCHRONOUS TERMINAL DRIVER

**************************************************************************

	These are the possible values of the first byte of a trace
	message passed back from the script to the driver.
	(These messages are "unsolicited messages".)

	These messages CANNOT BE SUPPRESSED.

*/



/*
	These values appear as the second byte of the trace messages
	which are generated by the script and passed back to the driver.
	(These messages are "unsolicited messages.")
*/

#define	FIRSTERR	0	/* first error number returnable to stsnoop */
#define NAKTRO	0		/* naks transmitted counter overflow */
#define	NAKRVO	1		/* naks recieved coutner overflow */
#define	WAKRVO	2		/* waks recieved counter overflow */
#define	RVITRO	3		/* waks received overflow */
#define	LRCFO	4		/* lrc failure overflow */
#define	CRCFO	4		/* crc failure overflow */
#define	SCCTO	5		/* scc time out threshold exceeded */
#define	SCCTE	6		/* scc to threshold exceeded */
#define	REXMTE	7		/* re transmit threshold exceeded */
#define	WAKTE	8		/* wak threshold exceeded */





/*

************************************************************************

	SOLICITED MESSAGES PASSED FROM THE SCRIPT TO THE 
		SYNCHRONOUS TERMINAL DRIVER

************************************************************************

	This is the order in which the error counters
	appear in the message, when returned to the host
	in response to a "SOLCMD" issued by the driver.
	(The message so returned is a "solicited message.")
*/

#define	LRCFCT	0		/* location of value of lrc failure counter */
#define	NAKTCT	1		/* location of value of retransmit counter */
#define	NAKRCT	2		/* location of value of naks rcvd counter */
#define	RVICT	3		/* location of value of rvi trnsmted counter */
#define	WAKRCT	4		/* location of value of waks rcved counter */
#define	SCCTOCT	5		/* location of value of scc time out counter */




/*

*************************************************************************

	BUFFER STATUS INDICATORS PASSED FROM THE SCRIPT TO THE
		SYNCHRONOUS TERMINAL DRIVER

*************************************************************************

	These are the possible values that will appear in rtype[0]
	on the kms side, and in octet1 on the vax side.
	These values indicate the status of the recieve buffers which are
	returned to the driver by a "rtnrbuf" primitive in the script.
*/

#define	FBLOCK	1		/* first message block from station */
#define	LBLOCK	2		/* last block from station - ETX	*/
#define	COUNTERS 4		/* this buffer contains error counters */


/*
	These are the possible values that will appear in xtype[0] on
	the kms side, and in octet1 on the vax side.
	These values indicate the status of transmit buffers which
	are returned to the driver by the "rtnxbuf" primitive in the
	script.
*/
#define	FRVI	1		/* transmit failure - excessive rvi's */
#define	FNAK	2		/* transmit failure - naks */
#define	FWAK	4		/* transmit failure - waks */
#define	FTO	4		/* transmit failure - time out */
#define	FGBG	8		/* transmit failure - garbage response */
#define	FEOT	16		/* transmit failure - EOT'ed */





/*

************************************************************************

	COMMANDS PASSED FROM THE SYNCHRONOUS TERMINAL DRIVER 
			TO THE SCRIPT

************************************************************************

	These are the possible commands that are passed from the
	the driver down to the script.
*/

#define	EDPCMD	0		/* enable/disable the polling */
#define	PRCMD	1		/* slow down the polling on a line */
#define	SOLCMD	2		/* pass the err counters back to driver */



/*

********************************************************************

	SENSE AND STATUS MESSAGES AS MODIFIED BY THE SYNCHRONOUS
	   TERMINAL DRVIER AND PASSED TO THE TRACE DRIVER

********************************************************************

	The following are returned by the driver in lieu of 
	sense and status messages.

	These messages CANNOT BE SUPPRESSED.

*/

#define	BADCMD	9	/* " A" - invalid command */
#define DVUNAV	10	/* " &" - device unavailable */
#define FRDVUNAV 11	/* " J" - from device unavailable */
#define TMGERR	12	/* " B" - internal timing error */
#define BFABT	13	/* " D" - block forward abort */
#define BADVCMD	14	/* " -" - invalid command for device */
#define	USS1	15	/* undefined sense and status: blank, ? */

#define	DVNBSY	16	/* "B " - device no longer busy */
#define	PPO	17	/* "B&" - printer out of paper */
#define	USS2	18	/* undefined sense and status: B, ? */

#define	BUFLOCK	19	/* "DA" - buffer locked */
#define	USS3	20	/* undefined sense and status: D, ? */
#define	USS4	21	/* undefined sense and status : H, ? */
#define	FRDVBSY	22	/* "HA" - from device busy */
#define	DVBSY	23	/* "H " - device busy	   */

/*

******************************************************************

	DEBUG (TRACE) MESSAGES PASSED FROM THE SCRIPT TO
		SYNCHRONOUS TERMINAL DRIVER

******************************************************************

	These are the debug messages that are returned 
	to the driver from the script.
	These messages CAN BE SUPPRESSED by compiling
	the script with DEBUG = 0.

*/

/* 
	(script event trace)
*/
#define	SCRSTR	24		/* script execution has started */
#define DSRHI	25		/* data set ready detected by script */
#define	SCRFAIL	26		/* script failure in listed state */

/*
	(script state trace)
*/
#define	SSR	27		/* 
				  script is searching for the attached
				  station cluster controller at the
				  desginated poll address
				*/
#define	TSR	28		/*
				  script is testing the listed response
				  from the station polled at prior address
				*/
#define	XBS	29		/*
				  script has transmitted the listed byte
				  to the station cluster controller
				*/
#define	POLL	30		/*
				  (this script state is not currently traced)
				*/
#define	POLLR	31		/*
				  a poll has been issued, and the response
				  to the poll is as listed.
				*/
#define	XMIT	32		/*
				  (this script state is not currently traced)
				*/
#define	XMITR	33		/*
				  the response to the SELECT has been 
				  recieved, and is as listed
				*/
#define	XMIT2	34		/*
				  (this script state is not currently traced)
				*/
#define	XMIT2R	35		/*
				  the transmission is complete, and the response
				  is as shown
				*/
#define	SEL	36		/*
				  attempting to SELECT the device at the listed
				  address
				*/
#define	DEVTERM	37		/*
				  script termination
				*/
#define TOCN	38		/* st terminal type ascii or ebcdic */
#define	LASTERR	38		/*
				  last error number returnable to stsnoop
				*/
