h06847
s 00118/00000/00000
d D 3.1 84/11/13 16:30:52 dan 1 0
c date and time created 84/11/13 16:30:52 by dan
e
u
U
t
T
I 1
/*  vwthandlr.c -- VIOS Write request handler
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */

#include "viosconf.h"
#include "devfuncs.h"
#include "pktfuncs.h"
#include "handlers.h"
#include "poolfuncs.h"
#include "viocmds.h"
#include "viostatus.h"


    PKT_STATE					/* Throws: various errors */
vwrt_handler (pkt)
    PKT_PTR pkt;

/* vwrt_handler (pkt) -- Process VIOS Write Requests
 *
 *	in:	pkt		Target i/o packet
 *	return:	(PKT_STATE)	next state of i/o packet
 *	thrown:	V_ILL_FUNCTION	function code not WRITE_DATA
 *		V_BAD_PARAMS	no i/o buffer address
 *				or auxilliary parameter supplied
 *		V_SUCCESS	successful completion (if no primary output)
 *
 *	Processes Virtual Write Requests as follows:
 *		1) Verify i/o function validity.  If bad function code,
 *			throw V_ILL_FUNCTION.
 *		2) Verify i/o buffer validity.  If no buffer, or if an
 *		   auxilliary parameter was supplied,
 *			throw V_BAD_PARAMS.
 *		3) If the output buffer size is zero,
 *			throw V_SUCCESS.
 *		4) If VIRTUAL OPERATING SYSTEM support,
 *		   call lock_buffer() (in hypersubs.c) to lock the i/o buffer
 *		   in memory.  Processing continues when the buffer is locked.
 *		5) If VIRTUAL OPERATING SYSTEM support,
 *		   call buf_io_alloc() (in hypersubs.c) to attempt to buffer
 *		   the request in pool.  If buffered i/o is possible,
 *		   copy the data from the request buffer to the pool buffer
 *		   and unlock the data buffer.  Then return DONE_WAIT_STATE
 *		   so that the child pkt may execute.
 *		6) If the target virtual device has a Journal-Output Unit
 *		   assigned, duplicate the packet, setting the target
 *		   device of the child to the parent's Journal Output device.
 *		   The child is put on the active queue and the parent
 *		   continues processing.  The child will restart at step (6).
 *		7) Call the Class Handler to continue the packet processing,
 *		   returning its return value.
 *		   If the Primary-Output device was a Virtual device, the
 *		   modified packet may be returned to this step later.
 *
 *		*** It may be desirable, in the future, to
 *			duplicate the packet during step (6)
 *			above, to preserve the original request ***
 *
 *	The result of the above processing is that the output request data
 *	is buffered, if possible, and all the output streams of the original
 *	target virtual device have individual i/o requests queued to them.
 *	The Class Handler is called for each remapping of one device to another,
 *	in order to properly handle device chains.
 */
{
    register IO_PACKET *pk;	/* dereferenced ptr */
    register VDD_PTR dev;

    pk = *pkt;		/* must renew after alloc() */

    switch (Stnum(pk))
	{
    case 0:
	if ( Fcode(pk) NE WRITE_DATA )
	    throw (V_ILL_FUNCTION);
	if ( (Auxparam(pk) NE NULL) OR (Ubufaddr(pk) EQ NULL) )
	    throw (V_BAD_PARAMS);

	if (Ubufsize(pk) EQ 0)  throw(V_SUCCESS);	/* zero length */

	/* chk_buffer() may throw V_BAD_BUFFER */
	chk_buffer(pkt);		/* buffer may be read-only */

	Stnum(pk)++;

#ifdef V_OS /************ VIRTUAL OPERATING SYSTEM SUPPORT *************/
	lock_buffer(pkt);	/* make sure buffer is locked */
#endif /***************** VIRTUAL OPERATING SYSTEM SUPPORT *************/

    case 1:
#ifdef V_OS /************ VIRTUAL OPERATING SYSTEM SUPPORT *************/
	if (buf_io_alloc(pkt))			/* attempt buffered write */
	    {
	    pk = *pkt;			/* refresh dereferenced ptr */
	    copy_buffer (&Ubuffer(pk), Auxparam(pk));	/* copy data */
	    unlock_buffer(pkt);		/* page may now be swapped out */
	    return(DONE_WAIT_STATE);	/* child will continue at next Stnum */
	    }

	Stnum(*pkt)++;			/* unbuffered i/o */
    
    case 2:
#endif /***************** VIRTUAL OPERATING SYSTEM SUPPORT *************/

	/* the current packet is either unbuffered i/o or a new pkt */

	o_dup(pkt);		/* start journal output, if any */

	/* Dispatch to Class Handler...if the target output device is */
	/* Virtual, processing will restart at this state with the new dev */

	dev = VDevice(*pkt);
	return((*Classdispatcher(*dev))(VDWRITE, pkt, dev));

	} /*switch Stnum*/
}
E 1
