h14812
s 00000/00015/00126
d D 1.3 84/11/09 03:23:33 dock 3 2
c really took out asm comments
e
s 00000/00000/00141
d D 1.2 84/11/09 03:22:35 dock 2 1
c took out asm comments in move command
e
s 00141/00000/00000
d D 1.1 84/11/01 22:37:34 dock 1 0
c date and time created 84/11/01 22:37:34 by dock
e
u
U
t
T
I 1
/* misc.c -- miscelleneous commands for monitor: display, move, compare
 * copyright (c) 1984  American Information Systems Corporation
 *  Dock Williams
 *  November, 1984
 *
 */

#include "monitor.h"



display(start,length)
    register int start;
    int length;
/*
 * display chunks of memory in hex and ascii
 */
{
    register int i, c, addr;
    register int end;
    char trans[18];

/* in the future possibly check if address range is valid at this point */

    addr = start & ~0x0f;
    end = start + length - 1;

    /* print a header */
    printf("address"); space(6);
    for(i=0;i<16;i+=2) {
	printf("%1x",i); space(4);
    }
    space(3); printf("*****ascii******\n");

    do {
	psym(addr);
	for (i=0; i<16; i++) {
	    if( (addr+i > end) || (addr+i < start) ) {
		trans[i] = ' '; space(2);
	    } else {
		c = trans[i] = membyte(addr+i);
		printf("%2x",c);
		if ( trans[i] < ' ' || trans[i] > '~' )
		    trans[i] = '.';
	    }
	    if ( i&0x01 ) space(1);
	}
	trans[16] = '\0';
	space(3); printf("%s\n",trans);
	if (quitchk()) return;
    } while ( (addr += 16) <= end );
}



move(from,to,length)
char *from;
char *to;
register int length;
{
	register char *fp;
	register char *tp;
	register int data;
	register int i;


	if ( (to > from) && (to <from+length) ) {
		fp = (char *)(from + length); 
		tp = (char *)(to + length); 
		for (i=length; i > 0; i--,fp--,tp--) {
		    data = membyte(fp);
		    wrtmbyte(tp, data);
		}
D 3
/*
**		asm("movd	 8(fp),r1");
**		asm("movd	12(fp),r2");
**		asm("movd	16(fp),r0");
**		asm("addr	-1(r1)[r0:b],r1");
**		asm("addr	-1(r2)[r0:b],r2");
**		asm("movsb	[b]");
*/

E 3
	} else {
		fp = from; 
		tp = to; 
		for (i=0; i < length; i++,fp++,tp++) {
		    data = membyte(fp);
		    wrtmbyte(tp, data);
		}
D 3
/*
**		asm("movd	 8(fp),r1");
**		asm("movd	12(fp),r2");
**		asm("movd	16(fp),r0");
**		asm("movsb");
*/
E 3
	}
}



fill(addr, length, data)
    char *addr; 
    int length, data; 
/*
 * write a block of memory with a specified pattern
 */
{
    register int i;
    register char *p;

#ifdef DEBUG1
printf("fill: addr:%x length:%x data%x\n",addr,length,data); /* DBG */
#endif

    p = addr;
    for(i=0; i<length; i++)
	wrtmbyte(&p[i], data);
}

/*
 * compare two blocks of memory
 */
compare(p1,p2,length)
register char *p1, *p2;
register int length;
{

#ifdef DEBUG1
printf("compare: p1:%x p2:%x length:%x\n",p1,p2,length); /* DBG */
#endif

    while (length--) {
	if(membyte(p1) != membyte(p2))
	    printf("%6x: %2x  %6x: %2x\n",(int)p1,*p1,(int)p2,*p2);
	if (quitchk()) return;
	p1++; p2++;
    }
}

space(n) register n; {while(n--) OUTCHR(' '); }

E 1
