h00003
s 00121/00000/00000
d D 3.1 84/11/13 16:30:40 dan 1 0
c date and time created 84/11/13 16:30:40 by dan
e
u
U
t
T
I 1
/*  viostypes.h -- Define low-level VIOS structures
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */
#ifndef VIOSTYPES
#define VIOSTYPES

/* Define general purpose structures */

typedef B8 PKT_STATE;		/* execution state of an i/o packet */
typedef UB8  PKT_STNUM;		/* i/o packet state number */
typedef PKT_STATE (*PKT_HANDLER)();	/* i/o packet handler routine address */
typedef UB8  PKT_PRIORITY;	/* i/o request priority */

typedef UB16 _IOCOUNT;		/* i/o count for devices or packets */
typedef int OS_IDENT;		/* <=0 : special os // >0 : os identifier */


typedef struct l_h_ead
	{
	struct l_h_ead **next;	/* first thing in queue */
	struct l_h_ead **last;	/* last thing in queue */
	}  LIST_HEAD;

#define Next(x)		((x)->next)
#define Last(x)		((x)->last)


typedef struct i_m	/* Implementation Module Descriptor */
	{
	struct i_m **next;	/* next module in queue */
	struct i_m **last;	/* previous module in queue */
	char **dname;		/* ASCIZ bufptr to imp. module name */
	PKT_STATE (*dispat)();	/* address of routine to dispatch commands */
	}  IMP_MODULE;

#define Imp_name(x)		((x)->dname)
#define Imp_dispatcher(x)	((x)->dispat)


typedef struct c_m	/* Class-Dependent Module Descriptor */
	{
	struct c_m **next;	/* next module in queue */
	struct c_m **last;	/* previous module in queue */
	PKT_STATE (*c_dispa)();	/* address of routine to dispatch commands */
	UB8 c_class;		/* Class handled by this descriptor */
	}  CLASS_MODULE;

#define C_class(x)		((x)->c_class)
#define C_dispatcher(x)		((x)->c_dispa)

typedef struct OS_DESCRIPTOR	/* Operating System Descriptor */
	{
	struct OS_DESCRIPTOR **next;	/* next os in queue */
	struct OS_DESCRIPTOR **last;	/* previous os in queue */
	char	**dname;		/* bufptr to os name */
	UB16 entrymod;		/* module number of current entry point */
	unsigned entryaddr;	/* address of current entry point */
	int (*kentry)();	/* address of user->kernel reschedule routine */
	LIST_HEAD c_queue;	/* completion queue */
	}  OSD, **OSD_PTR;

#define O_name(x)		((x)->dname)
#define O_entrymod(x)		((x)->entrymod)
#define O_entryaddr(x)		((x)->entryaddr)
#define O_kentry(x)		((x)->kentry)
#define O_cqueue(x)		((x)->c_queue)

typedef struct os_c		/* Operating System Completion Descriptor */
	{
	struct os_c **next;	/* next in queue */
	struct os_c **last;	/* previous in queue */
	int (*crout)();		/* completion routine descriptor */
	unsigned carg;		/* argument to completion routine */
	int** spkt;		/* source pkt (only valid if multi-int pkt) */
	}  OS_COMP;

#define O_crout(x)		((x)->crout)
#define O_carg(x)		((x)->carg)
#define O_cpkt(x)		((x)->spkt)

/* Define Buffer-Mapping table structure */
typedef struct
	{
	int bfsize;		/* number of bytes mapped by this entry */
	char *bfaddr;		/* physical address for this entry */
	}  MAP_LIST;

#define Msize(x)	((x)->bfsize)
#define Maddr(x)	((x)->bfaddr)


/* Define VIOS Pool Management structures */

typedef struct			/* 1st words of a pool buffer */
	{
	unsigned bfsize;	/* size of free or allocated data area */
	int *bfnext;		/* points to next free buffer of bufptr */
	int *bfprev;		/* points to prev free buffer */
	}  PHDR;

typedef struct			/* Compressible Pool Management Buffer */
	{
	PHDR	 *freebuf;	/* ptr to first free buffer */
	int	 *freeptr;	/* ptr to first free bufptr */
	int      *low;		/* address of start of bufptrs */
	int	 *ptrtop;	/* address of start of buffer pool */
	int      *high;		/* first address after buffer pool */
	PHDR	 *pktlist;	/* ptr to linked, pre-allocated IO_PACKETS */
	unsigned  freetot;	/* total free pool (units of sizeof(int*)) */
	unsigned  maxptrs;	/* maximum number of bufptrs allowed */
	unsigned  numfptrs;	/* number of free bufptrs */
	unsigned  numfbufs;	/* number of holes in buffer space */
	unsigned  numpkts;	/* number of packets in pktlist */
	unsigned  numcomps;	/* number of compression executions */
	}  POOL_MGE;


#endif
E 1
