h52782
s 00023/00071/00038
d D 3.2 85/02/13 00:21:53 dan 2 1
c Added HOST-MEMORY device dispatching / clean-up / updated comments
e
s 00109/00000/00000
d D 3.1 84/11/13 16:26:37 dan 1 0
c date and time created 84/11/13 16:26:37 by dan
e
u
U
t
T
I 1
/*  aisdispat.c -- Dispatcher for on-board AIS devices
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */

#include "viosconf.h"
#include "iopacket.h"
#include "viocmds.h"
#include "viostatus.h"
#include "handlers.h"


    PKT_STATE					/* Throw: Errors from drivers */
ais_dispatcher (cmd, dev, pkt)
    int cmd;
    PDD_PTR dev;
    PKT_PTR pkt;

/* ais_dispatcher (cmd, dev, pkt)
 *	in:	cmd		dispatcher function (PDCREATE / PDREMOVE / etc)
 *	in:	dev		bufptr to physical device descriptor
 *	in:	pkt		bufptr to active i/o packet
 *	return:	(PKT_STATE)	current state of i/o packet
 *	thrown:	(?)		(Drivers may throw errors...see note 1 below)
 *
 *	Main dispatcher for AIS local devices (devices whose physical names
D 2
 *	begin with the string "AIS:").  Typically, this dispatcher will not
 *	be called for device creation or removal (PDCREATE or PDREMOVE) with
 *	an active i/o packet, since all device initialization should occur at
 *	initial system startup.
E 2
I 2
 *	begin with the string "AIS:").  This dispatcher might be called for
 *	device creation (PDCREATE) without an active i/o packet, since some
 *	device initialization occurs at initial system startup.
E 2
 *
D 2
 *	The following should be noted concerning device dispatchers:
 *		1) 'pkt' is assumed to be the i/o packet that is currently
 *		   being dispatched through main_dispatcher() (in viomain.c).
 *		   If this is not the case, if an error condition is thrown,
 *		   it must be caught upstream before
 *		   it reaches main_dispatcher() if it could terminate the
 *		   wrong i/o packet.
E 2
I 2
 *	This routine typically resets the dispatcher address to the appropriate
 *	dispatcher for the specified device type.  Therefore, all requests
 *	other than PDCREATE are handled elsewhere.
E 2
 *
D 2
 *		2) Device dispatchers are typically called by q2device()
 *		   (in rdwrtsubs.c) which is mostly called by the class
 *		   dispatching modules (blkaddr.c, recseq.c, etc.).
 *		   Those routines should be referred to for more specifics
 *		   on the conditions under which the dispatcher is requested
 *		   when the 'cmd' is STARTIO.
 *
 *		3) A STARTIO request will not be dispatched if the device
 *		   has its current packet non-NULL (Devipkt / Devopkt | Devpkt).
 *		   Therefore, single-request devices must ensure that the
 *		   current packet pointer slot is maintained correctly;
 *		   multi-request devices (e.g. host disk devices) must keep
 *		   that slot (or slots, if full-duplex) clear.
 *
E 2
 */
{
I 2
    register char *name;
E 2

D 2
/* NOTE: This must be replaced with real dispatching when there's > 1 device */
E 2
I 2
#ifdef DEBUG3   /*************************************************************/
    if (cmd NE PDCREATE)
	error ("Bad cmd to ais_dispatcher: %d", cmd);
#endif /* DEBUG3 *************************************************************/
E 2

D 2
    switch (cmd)
E 2
I 2
    name = *Devname(*dev) + AISSTRL;	/* point to device name after AIS: */

    if (strncmp(name, UARTSTR, UARTSTRL) EQ 0)		/* if TTY... */
E 2
	{
D 2
    case PDCREATE:
	return(tty_create(dev,pkt));
E 2
I 2
	Dispatcher(*dev) = (int(*)()) tty_dispatcher;	/* set new dispatcher */
	return(tty_create(dev,pkt));		/* call driver directly */
	}
E 2

D 2
    case PDREMOVE:
	return(tty_remove(dev,pkt));
E 2
I 2
    if (strncmp(name, HOSTMEM, HOSTMEML) EQ 0)	/* if HOSTMEM... */
	{
	Dispatcher(*dev) = (int(*)()) hmem_dispatcher;	/* set new dispatcher */
	return(hmem_create(dev,pkt));		/* call driver directly */
	}
E 2

D 2
    case STARTIO:
	switch (Devclass(*dev))
	    {
	case REC_SEQ:
	    switch (Ftype(*pkt))
		{
	    case DEVICE_FUNCTION:
		return(tty_control(dev,pkt));

	    case WRITE_FUNCTION:
		return(tty_write(dev,pkt));

	    case READ_FUNCTION:
		return(tty_read(dev,pkt));

#ifdef DEBUG4   /*************************************************************/
	    default:
	error ("Bad i/o function in ais_dispatcher: %d", Function(*pkt));
#endif /* DEBUG4 *************************************************************/

		} /*switch - Ftype*/

#ifdef DEBUG4   /*************************************************************/
	default:
	error ("Bad device class in ais_dispatcher: %d", Devclass(*dev));
#endif /* DEBUG4 *************************************************************/

	    } /*switch - Devclass*/

#ifdef DEBUG_MAP   /***********************************************************/
    case PDMAPPOOL:
	return(tty_mappool(dev,pkt));
#endif /* DEBUG_MAP ***********************************************************/

#ifdef DEBUG4   /*************************************************************/
    default:
	error ("Bad cmd to ais_dispatcher: %d", cmd);
#endif /* DEBUG4 *************************************************************/

	} /*switch - cmd*/
E 2
I 2
    throw(V_NO_DEVICE);				/* no such device */
E 2
}
E 1
