/*  devhandlr.c -- VIOS Virtual Device I/O Control request handler
 *  copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	November, 1984
 *
 */

#include "viosconf.h"
#include "devfuncs.h"
#include "pktfuncs.h"
#include "handlers.h"
#include "poolfuncs.h"
#include "viocmds.h"
#include "viostatus.h"


    PKT_STATE					/* throws: various errors */
vdevice_handler (pkt)
    register PKT_PTR pkt;

/* vdevice_handler (pkt) -- Process VIOS VDEV_CONTROL requests
 *
 *	in:	pkt		I/O packet to process
 *	return:	(PKT_STATE)	next state of packet
 *	thrown:	V_ILL_FUNCTION	function not valid
 *		V_BAD_PARAMS	
 *		V_NO_DEVICE	no Primary Input device
 *
 *	Process Virtual I/O Control Requests in the following way:
 *
 */
{
    register IO_PACKET *pk;	/* dereferenced ptr */
    register VDD_PTR dev;

    pk = *pkt;		/* must renew after alloc() */

    switch (Stnum(pk))
	{
    case 0:
	if ( (Auxparam(pk) NE NULL) OR (Ubufsize(pk) NE 0) )
	    throw (V_BAD_PARAMS);

	dev = VDevice(pk);		/* get device and go to Class Handler */

	/* if i/o redirection is performed, spawned packets may come back */
	return((*Classdispatcher(*dev))(VDIOCTRL,pkt,dev));

#ifdef DEBUG2   /*************************************************************/
    default:
	error("vdevice_handler: bad state in pkt @ %x", pk);
#endif /* DEBUG2 *************************************************************/

	} /*switch Stnum*/
}

    PKT_STATE					/* throws: various errors */
pdevice_handler (pkt)
    register PKT_PTR pkt;

/* pdevice_handler (pkt) -- Process VIOS PDEV_CONTROL requests
 *
 *	in:	pkt		I/O packet to process
 *	return:	(PKT_STATE)	next state of packet
 *	thrown:	V_ILL_FUNCTION	function not valid
 *		V_BAD_PARAMS	
 *		V_NO_DEVICE	no Primary Input device
 *
 *	Process Physical I/O Control Requests in the following way:
 *
 */
{
    register IO_PACKET *pk;	/* dereferenced ptr */
    register PDD_PTR dev;

    pk = *pkt;		/* must renew after alloc() */

    switch (Stnum(pk))
	{
    case 0:
	if ( (Auxparam(pk) NE NULL) OR (Ubufsize(pk) NE 0) )
	    throw (V_BAD_PARAMS);

	dev = PDevice(pk);		/* get device and go to Class Handler */

	return((*Classdispatcher(*dev))(PDIOCTRL,pkt,dev));

#ifdef DEBUG2   /*************************************************************/
    default:
	error("pdevice_handler: bad state in pkt @ %x", pk);
#endif /* DEBUG2 *************************************************************/

	} /*switch Stnum*/
}
