
/*
 * rtc.h
 * Include file for TOD 
 */

typedef struct {	/* offset - R/W, usage, legal values */
	byt	control;	/* 0 - split R/W control register */
	byt	tenthsec;	/* 4 - read only, tenths of seconds; 0-9 */
	byt	sec;		/* 8 - R/W, unit seconds; 0-9 */
	byt	tensec;		/* c - R/W, tens of seconds; 0-5 */
	byt	min;		/* 10 - R/W, unit minutes; 0-9 */
	byt	tenmin;		/* 14 - R/W, tens of minutes; 0-5 */
	byt	hour;		/* 18 - R/W, unit hours; 0-9 */
	byt	tenhour;	/* 1c - R/W, tens of hours; 0 or 1 */
	byt	dayom;		/* 20 - R/W, day of month, unit; 0-9 */
	byt	tendayom;	/* 24 - R/W, tens of day of month; 1-3 */
	byt	month;		/* 28 - R/W, unit month; 0-9 */
	byt	tenmonth;	/* 2c - R/W, tens of months; 0 or 1 */
	byt	year;		/* 30 - R/W, units year; 0-9  */
	byt	tenyear;	/* 34 - R/W, tens of years; 0-9 */
	byt	weekday;	/* 38 - R/W, day of week; 1-7 */
	byt	interrupt;	/* 3c - interrupt control */
} RTC;

/* structure for holding time */
typedef struct {
	unsigned char	tenthsec;
	unsigned char	sec;	
	unsigned char	tensec;
	unsigned char	min;
	unsigned char	tenmin;
	unsigned char	hour;
	unsigned char	tenhour;
	unsigned char	dayom;
	unsigned char	tendayom;
	unsigned char	month;	
	unsigned char	tenmonth;
	unsigned char	year;	
	unsigned char	tenyear;
	unsigned char	weekday;
} TIMEVAL;

/* control register definitions */
#define RTC_INIT	0x0f		/* disable interrupts */
					/* stop clock and interrupt timers */
#define RTC_CLKSET	0x05		/* select normal, clock setting */
					/* clock and interrutps stopped */
#define	RTC_START	0x00		/* start the real time clock */

/* interrupt register definitions */
#define	RTC_NOINTS	0x00		/* no interrupts */
#define RTC_24HOUR	0x01		/* set 24 hour mode */

