/*  ascii.h -- Define symbolic names for ASCII character set
 *  copyright (c)
 *	Daniel Steinberg
 *	September, 1983
 *
 */
#ifndef ASCII
#define ASCII

/* Define control characters */
#define CTRL_A '\001'
#define CTRL_B '\002'
#define CTRL_C '\003'
#define CTRL_D '\004'
#define CTRL_E '\005'
#define CTRL_F '\006'
#define CTRL_G '\007'
#define CTRL_H '\010'
#define CTRL_I '\011'
#define CTRL_J '\012'
#define CTRL_K '\013'
#define CTRL_L '\014'
#define CTRL_M '\015'
#define CTRL_N '\016'
#define CTRL_O '\017'
#define CTRL_P '\020'
#define CTRL_Q '\021'
#define CTRL_R '\022'
#define CTRL_S '\023'
#define CTRL_T '\024'
#define CTRL_U '\025'
#define CTRL_V '\026'
#define CTRL_W '\027'
#define CTRL_X '\030'
#define CTRL_Y '\031'
#define CTRL_Z '\032'

#define CTRL_OSB '\033'		/* control-open-square-bracket */
#define CTRL_BS  '\034'		/* control-backslash */
#define CTRL_CSB '\035'		/* control-close-square-bracket */
#define CTRL_UA  '\036'		/* control-up-arrow */
#define CTRL__   '\037'		/* control-underline */

/* Define other special characters */
#define BELL		'\007'
#define BACKSPACE	'\010'
#define TAB		'\011'
#define LINEFEED	'\012'
#define LF		'\012'
#define VTAB		'\013'
#define FORMFEED	'\014'
#define RETURN		'\015'
#define CR		'\015'
#define ESCAPE		'\033'
#define ESC		'\033'
#define SPACE		'\040'
#define RUBOUT		'\177'
#define DELETE		'\177'

#define XON		'\021'
#define XOFF		'\023'


#endif
