/* sym.c -- symbol table manipulation routines for debugging monitor
 * copyright (c) 1984  American Information Systems Corporation
 *  Dock Williams
 *  October, 1984
 *
 */

#include "monitor.h"
#include "vctype.h"


struct symbol *fsym(sp, s)
    register struct symbol *sp;
    register char *s;
/*
 * find a symbol in the symbol table
 */
{
    for(;sp != NULL; sp = sp->next) {
	    if(same(s, sp->name))
	        return(sp);
    }
    return((struct symbol *)NULL);
}



asym(s, val, sflags)
    register char *s;
    register unsigned val;
    int sflags;
/*
 * add a symbol to the symbol table
 */
{
    register unsigned i;
    register struct symbol *nsp, *lsp;
    struct symbol *allocsym(); 
    unsigned size;

    if ( (size = strlen(s)) > MAXNAM-1) {
	    s[size = (MAXNAM-1)] = '\0';	/* reduce size of symbol */
    }

#ifdef DEBUG2
	printf(" + %s",s);
#endif

    dsym(s);		/* if its already there, delete it and add it */

    if ((nsp = allocsym()) == (struct symbol*)NULL) return;

    if (sflags) {
	    nsp->flags |= sflags;	/* or in hidden symbol flags */
    }

    bzero(nsp->name,MAXNAM);		/* clear name */

    for(i=0; i<=size; i++) {
	    if( (isalpha(s[i])||isdigit(s[i])||(s[i]=='_')) )
	        nsp->name[i] = s[i];
	    else {
	        if(s[i] == '\0' && i) break;
	        else {
		        printf("bad symbol");
		        nsp->flags = 0;
		        return;
	        }
	    }
    }
    nsp->value = val;

    /* this case is the first and only entry in the symbol table */
    if(symstart == NULL) {
	    nsp->prev = nsp->next = NULL;
	    symstart = symtab;
	    return;
    }

    /* insert in symbol table, sorted by value */
    /* we use this for offset addressing */
    for(lsp = symstart; lsp != NULL; lsp = lsp->next) {
	    if(lsp->value >= val) {
	        if(lsp->prev) lsp->prev->next = nsp;
	        else symstart = nsp;
	        nsp->next = lsp;
	        nsp->prev = lsp->prev;
	        lsp->prev = nsp;
	        return;
	    }
    }

/* if we get here we have to append it at the end of the symbol table */
    for(lsp = symstart; lsp->next; lsp = lsp->next);
    lsp->next = nsp;
    nsp->prev = lsp;
    nsp->next = NULL;
}



dsym(s)
    char *s;
/*
 * delete a symbol from the symbol table
 */
{
    register struct symbol *sp;
    struct symbol *fsym();

    if((sp = fsym(symstart, s)) != NULL) {
	    if(sp->prev != NULL) {
	        sp->prev->next = sp->next;
	    } else symstart = sp->next;
	    if(sp->next != NULL) {
	        sp->next->prev = sp->prev;
	    }
	sp->flags = 0;
    }
}



    static
same(ptrn,str)
    register char *ptrn, *str;
/*
 * check two strings to see if they are the same
 * allow for some wildcards
 */
{
    register char *p, *es;

    for(es = &str[strlen(str)-1]; *ptrn; ptrn++, str++) {
	switch(*ptrn) {
	case '\\':	ptrn++;
	default:	if(*ptrn != *str) return(0);
			break;
	case '*':	if(!ptrn[1]) return(1);
			for(p = es; p>= str; p--)
				if(same(&ptrn[1],p))return(1);
			return(0);
	case '?':	if(!str)
			    return(0);
	}
    }
    return(*str == '\0');
}



lsym(s)
    register char *s;
/*
 * list symobl table entries (allowing wildcards)
 */

{
    register struct symbol *sp;
    register int i, j, k;

    sp = symstart;
    do	{
	for(i=0;i<3;i++) {
	    for (sp = fsym(sp, s); sp !=NULL; sp = sp->next) {
		if ( !(sp->flags & S_HIDE) ) break;
		else if(cflags & CF_PHIDE) break;
	    }
	    if(sp != NULL) {
		printf("%9s ", sp->name);
		printf("= %8x      ", sp->value);
		sp = sp->next;
	    } else break;
	    if (quitchk()) {
		sp = (struct symbol *)NULL;
		break;
	    }
	}
	if(i != 0) OUTCHR('\n');
    } while (sp != NULL);
    return;
}



init_sym()
/*
 * initialize the symbol table
 */
{
    register struct symbol *sp;

#ifdef DEBUG2
    printf("\nClearing symbol table -- old symstart = %x\n", symstart);
#endif
    symstart = NULL;

    for(sp = &symtab[0]; sp < &symtab[MAXSYM+1]; sp++) sp->flags = 0;
}



    struct symbol 
*allocsym()
/*
 * allocate a symbol table entry
 */
{
    register struct symbol *sp;

    for(sp = &symtab[0]; sp < &symtab[MAXSYM+1]; sp++) {

#ifdef DEBUG2
    printf("Check symbol table entry at %x %x\n", sp,sp->flags);
#endif

	if( !(sp->flags & S_USED) ) {
	    sp->flags |= S_USED;
	    return(sp);
	}
    }
    printf("full\n");
    return((struct symbol *)NULL);
}


psym(val)
    register int val;
/*
 * print values for symbols
 * search for value in symbol table
 */
{
    register struct symbol *sp;
    register int i;
    register char *sn;
    char temp[MAXNAM];

    for(sp = symstart; sp != NULL; sp = sp->next) {
	if ( (sp->value > val) &&
	     (sp->prev !=NULL) && ((val-sp->prev->value) <= 0xffe) ) {
		if ( !(cflags & CF_SYMP) ) break;
		printf("%s+%3x",
		    sp->prev->name, val-sp->prev->value);
		space(MAXVBS-strlen(sp->prev->name));
		return;
	} else if ( (sp->value == val) &&
		    ((sp->flags & S_SHIDE) ||
		     (cflags & CF_SYMP)) ) {
		printf("%12s ",sp->name);
		return;
	}
    }
    printf("%6x",val);
    space(MAXVBS+4-6);
}

