/* ramstart.S -- Initialize RAM-Monitor and VIOS and start-up system
 * copyright (c) 1984  American Information Systems Corporation
 *	Daniel Steinberg
 *	July, 1984
 */

#include "promhdr.h"
#include "vmdispatch.h"
#include "cflags.h"
#include "RAMmonaddr.m"

	.file "ramstart.S"
	
	.text
	.globl	start_VIOS

start_VIOS:

	lprd	sp,$A_viosstack		/* set VIOS stack */
	addr	@A_viosdispatch,@A_state	/* initial processing state */
	jsr	_mon_init		/* initialize the RAM-Monitor */
	jsr	_vios_init		/* and initialize the VIOS */

restart:
	jsr	_vios_cmd_entry		/* start VIOS command interpreter */
	jsr	_mon_start		/* <CR>...start RAM-Monitor */
	br	restart			/* user 'proceed'...try again */
