/* ramsize.c -- C source to create RAMramsize.m
 * copyright (c) 1984  American Information Systems Corporation
 *
 *	Daniel Steinberg
 *	July, 1984
 *
 *	This file is compiled to produce assembly language output that
 *	is editted (thru abs.sed) to become RAMramsize.m in which the
 *	initialized values below are turned into assembler .set directives.
 *	RAMramsize.m is assembled and linked with the RAM-Monitor/VIOS
 *	to define the end of the Absolute-Addressed RAM area.
 *
 */

#include "monflags.h"

/* Define macros to make symbol definitions */

#define Makeval(x,v) unsigned A_/**/x = (unsigned)(v);


/* Define some special locations and values */

#define ABSRAMSTART (((unsigned) RAMSTART) & (~(GRAIN-1)))
#define ABSRAMGRAINS ((sizeof(MONITOR_RAM) + GRAIN - 1) / GRAIN)
#define ABSRAMSIZE (ABSRAMGRAINS * GRAIN)

Makeval(ramstart, ABSRAMSTART)
Makeval(ramend, (ABSRAMSTART + ABSRAMSIZE))
Makeval(ramgrains, ABSRAMGRAINS)
Makeval(ramsize, ABSRAMSIZE)


