/* xsrodata.c -- read only data for the ram monitor
 *	(stuff that can be 'xsrtinged')
 * copyright (c) 1984  American Information Systems Corporation
 *  Dock Williams
 *  July, 1984
 */

/* file that has the typedefs for the debugger monitor */
#include "promhdr.h"
#include "mondef.h"

/* trap name table */

extern char rsv[], vec[];	/* strings defined in rodata.c */

char *trapname[] = {
"NVI", "NMI", "ABT", "FPU", "ILL", "SVC", "DVZ", "FLG",
"BPT", "TRC", "UND",  rsv,   rsv,   rsv,   rsv,   rsv,
vec,    vec,   vec,   vec,   vec,   vec,   vec,   vec,
vec,    vec,   vec,   vec,   vec,   vec,   vec,   vec
};

/* used in disasm.c */

INSTFORM format[] = {
"B/",
"cccc1010",
"Bsr/Ret/Cxp/Rxp/Rett/reti/save/restore/Enter/exit/nop/wait/dia/flag/svc/bpt",
"xxxx0010",
"s/",
"22222cccc01111bb",
"spr/lpr",
"22222PPPPx1011bb",
"addq/cmpq///Acb/movq",
"22222ssssxxx11bb",
"cxpd//bicpsr//jump//bispsr////adjsp//jsr//case",
"22222xxxx11111bb",
"add/cmp/bic//addc/mov/or//sub/addr/and//subc/tbit/xor",
"mmmmm22222xxxxbb",
"setcfg",
"00000CCGG00010--00001110",
"movs/cmps//skps",
"00000SSSS0xxxxbb00001110",
"rot/ash/cbit/cbiti//lsh/sbit/sbiti/neg/not//subp/abs/com/ibit/addp",
"mmmmm22222xxxxbb01001110",
"Movm/Cmpm/inss/exts/movxbw/movzbw/movz/movx/mul/mei//dei/quo/rem/mod/div",
"mmmmm22222xxxxbb11001110",
"Ext/cvtp/Ins/check",
"mmmmm22222RRR0bbxx101110",
"index/ffs",
"mmmmm22222RRR1bb0x101110",
"movsu/movus",
"mmmmm222220x11bb10101110",
"mov/lfsr/movlf/movfl/round/trunc/sfsr/floor",
"mmmmm22222xxxfbb00111110",
"add/mov/cmp//sub/neg///div////mul/abs",
"mmmmm22222xxxx0f10111110",
"rdval/wrval/lmr/smr",
"22222MMMM0xxxx1100011110",
"\0","\0"
};

char  *fieldtab[] = {
"eq/ne/cs/cc/hi/ls/gt/le/fs/fc/lo/hs/lt/ge/r",
"b/w//d",
"/t/b/tb/w/tw/bw/tbw/////u/tu/bu/tbu",
"/m/c/cm",
"/i/f/fi",
"r0/r1/r2/r3/r4/r5/r6/r7",
"us////////fp/sp/sb/pc//psr/intbase/mod",
"bpr0/bpr1///pf0/pf1///sc//msr/bcnt/ptb0/ptb1//eia",
"0/1/2/3/4/5/6/7/-8/-7/-6/-5/-4/-3/-2/-1",
"l/f",
"\0"
};

/* used synop.c */
extern char cmdc[];
extern char cmdcsyn[];
extern char cmdd[];
extern char cmddsyn[];
extern char cmdf[];
extern char cmdfsyn[];
extern char cmdg[];
extern char cmdgsyn[];
extern char cmdh[];
extern char cmdhsyn[];
extern char cmdi[];
extern char cmdisyn[];
extern char cmdm[];
extern char cmdmsyn[];
extern char cmdo[];
extern char cmdosyn[];
extern char cmdz[];
extern char cmdzsyn[];

SYNOP cmdtab[] = {
    '?',"help","{cmd} ?",
    '+',"add sym","<sym> <value> +",
    '#',"delete sym","<sym> #",
    'o', cmdo, "{addr} < /(double), \\(word), `(byte) > \n\r                {(<o,d,x,c,s,u>$) | @ | <count>(+|-) | <val>(LF|^|CR) }",
   	'o',0,"output format {<o,d,x,c,s,u>$}",
    	'o',0,"next       {<count>+, <LF>}   use as pointer    @",
    	'o',0,"previous   {<count>-, ^}      write and quit    {val} <CR>",
    '$',"output format", "{<b,o,d,x,c,u>$}",

#ifdef AUTOP
    'a',"autoprint","{<;<autoprint string>;>} a",
#endif

    'b',"breakpoint","<addr> {count} {-|(r,w,x,p,a,(1|0))} b",
    'c', cmdc, cmdcsyn,
    'd', cmdd, cmddsyn,
    'e',"enable","{-} <a,s,h,t,m,p,u,*> e",

#ifdef AUTOP
	'e',0,"a : auto-print",
#endif

	'e',0,"h : hidden symbol",
	'e',0,"s : symbolic address",

#ifdef MMUBRK
	'e',0,"m : mmu bpt",
#endif MMUBRK

	'e',0,"p : physical address",
	'e',0,"u : user-state debug",
    'f', cmdf, cmdfsyn,
    'g', cmdg, cmdgsyn,
    'i', cmdi, cmdisyn,

#ifdef MONJSR
    'j',"jsr","<addr> {arg0} {arg1} {arg2} j",
#endif MONJSR

    'l',"list symbols","<symbol spec> l",

/*	'l',0,"* any string of characters    ? any character",	*/

    'm', cmdm, cmdmsyn,
    'p',"proceed","{count} p",
    'r',"registers","{c,f,m} r",
    's',"step","{count} s | , (single) | < (step thru jsr)",

#ifdef STRACE
    't',"trace stack","t",
#endif STRACE

    'u',"unassemble","<addr> <count> u",
    'x',"ROM-Monitor","x",
    'z', cmdz, cmdzsyn,
    0,0,0
};

