h62692
s 00005/00005/00109
d D 1.3 85/05/31 18:43:08 dock 3 2
c instruction optimizations
e
s 00008/00008/00106
d D 1.2 85/02/13 00:38:59 dock 2 1
c changes for new assembler
e
s 00114/00000/00000
d D 1.1 84/11/01 22:38:31 dock 1 0
c date and time created 84/11/01 22:38:31 by dock
e
u
U
t
T
I 1
/* romtrap.S -- ROM-Monitor trap handling
 * copyright (c) American Information Systems Corporation
 *	Daniel Steinberg
 *	July, 1984
 *
 *	AIS/UNIX-System V.2  code format
 *
 *	This file establishes an interrupt dispatch table and module table entry
 *	for trap handling within the AIS/ROM-Monitor.  The module table entry
 *	is accessed in the low 64K-bytes of address space only when ROM is
 *	mapped over RAM.  Therefore, traps will not be handled correctly once
 *	RAM-Mapping is enabled.
 *
 */
	.text

/* define macro to compute local routine offsets */
#define VECTOR(x)	.word	(ROMMODTBL - addr0), ((x) - ROMDISPATCH)

	.align	4

ROMMODTBL:		/* ROM-Monitor Interrupt Module Table Entry */
ROMSB:	.double	0
ROMLB:	.double	0
ROMPB:	.double	ROMDISPATCH
	.double	0

	.globl	ROMVECTORS
ROMVECTORS:		/* ROM-Monitor Interrupt Dispatch Table */
	VECTOR(ROMnvi)
	VECTOR(ROMnmi)
	VECTOR(ROMabt)
	VECTOR(ROMfpu)
	VECTOR(ROMill)
	VECTOR(ROMsvc)
	VECTOR(ROMdvz)
	VECTOR(ROMflg)
	VECTOR(ROMbpt)
	VECTOR(ROMtrc)
	VECTOR(ROMund)
	VECTOR(ROMrsv)
	VECTOR(ROMrsv)
	VECTOR(ROMrsv)
	VECTOR(ROMrsv)
	VECTOR(ROMrsv)
	/* Interrupt handlers (interrupts ordinarily disabled) */
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)
	VECTOR(ROMvec)


/* trap routines */
ROMDISPATCH:

ROMnvi:
D 2
        movqd   0,r0		/* trap number 0 */
E 2
I 2
        movqd   $0,r0		/* trap number 0 */
E 2
        br      ROMtrap
ROMnmi:
D 2
        movqd   1,r0		/* trap number 1 */
E 2
I 2
        movqd   $1,r0		/* trap number 1 */
E 2
        br      ROMtrap
ROMabt:
D 2
        movqd   2,r0		/* trap number 2 */
E 2
I 2
        movqd   $2,r0		/* trap number 2 */
E 2
        br      ROMtrap
ROMfpu:
D 2
        movqd   3,r0		/* trap number 3 */
E 2
I 2
        movqd   $3,r0		/* trap number 3 */
E 2
        br      ROMtrap
ROMill:
D 2
        movqd   4,r0		/* trap number 4 */
E 2
I 2
        movqd   $4,r0		/* trap number 4 */
E 2
        br      ROMtrap
ROMsvc:
D 2
        movqd   5,r0		/* trap number 5 */
E 2
I 2
        movqd   $5,r0		/* trap number 5 */
E 2
        br      ROMtrap
ROMdvz:
D 2
        movqd   6,r0		/* trap number 6 */
E 2
I 2
        movqd   $6,r0		/* trap number 6 */
E 2
        br      ROMtrap
ROMflg:
D 2
        movqd   7,r0		/* trap number 7 */
E 2
I 2
        movqd   $7,r0		/* trap number 7 */
E 2
	br      ROMtrap
ROMbpt:
D 3
        movzbd  $8,r0		/* trap number 8 */
E 3
I 3
        addr	@8,r0		/* trap number 8 */
E 3
	br	ROMtrap
ROMtrc:
D 3
        movzbd  $9,r0		/* trap number 9 */
E 3
I 3
        addr	@9,r0		/* trap number 9 */
E 3
	br	ROMtrap
ROMund:
D 3
        movzbd  $10,r0		/* trap number 10 */
E 3
I 3
        addr	@10,r0		/* trap number 10 */
E 3
	br	ROMtrap
ROMrsv:
D 3
        movzbd  $11,r0		/* reserved traps */
E 3
I 3
        addr	@11,r0		/* reserved traps */
E 3
	br	ROMtrap
ROMvec:
D 3
        movzbd  $16,r0		/* vectored interrupts */
E 3
I 3
        addr	@16,r0		/* vectored interrupts */
E 3

ROMtrap:
	addr	_romtrapmsg,r6	/* get address of prefix string */
	addr	trap2,r7	/* set return address */
	jump	printmsg	/* print message */
trap2:
	movd	_trapname[r0:d],r6	/* get address of trap name string */
	addr	ramless_quiet,r7	/* return to ROM-Monitor */
	jump	printmsg		/* after printing trap type */
E 1
