
/* @(#)math.s	1.0 */
/* 8/20/84 */

/*
 *	udiv - unsigned division for n16
 *
 *	arguments: dividend, divisor.
 *	result: quotient.
 *	uses r0-r2
 *
 *	If 1 < divisor <= 2147483647, zero-extend the dividend
 *	to 64 bits and let ediv do the work.  If the divisor is 1,
 *	ediv will overflow if bit 31 of the dividend is on, so
 *	just return the dividend unchanged.  If the divisor is 0,
 *	do the ediv also, so it will generate the proper exception.
 *	All other values of the divisor have bit 31 on: in this case
 *	the quotient must be 0 if divisor > dividend, and 1 otherwise,
 *	provided that the comparison is made as unsigned.
 *	All the Above comments not applicable for the 16000.
 */
	.text
	.globl	udiv
udiv:
	movd	4(sp),r0	/* Dividend */
	movd	8(sp),r2	/* Divisor */
	movqd	0,r1		/* Clear Hi register */
	deid	r2,r0		/* extended divide */
	movd	r1,r0		/* quotient */
	ret	0

/*
 *	urem - unsigned remainder for n16
 *
 *	arguments: dividend, divisor
 *	result: remainder
 *	uses r0-r2
 *
 *	if 1 < divisor <= 2147483647, zero-extend the dividend
 *	to 64 bits and let ediv do the work.  If the divisor is 1,
 *	ediv will overflow if bit 31 of the dividend is on, so
 *	just return 0.  If the divisor is 0, do the ediv also,
 *	so it will generate the proper exception.  All other values
 *	of the divisor have bit 31 on: in this case the remainder
 *	must be the dividend if divisor > dividend, and the dividend
 *	minus the divisor otherwise.  The comparison must be unsigned.
 *	All above comments not applicable to the 16000
 */
	.text
	.align	2
	.globl	urem
urem:
	movd	4(sp),r0	/* Dividend */
	movd	8(sp),r2	/* Divisor */
	movqd	0,r1		/* Clear Hi register */
	deid	r2,r0		/* Remainder in r0 */
	ret	0	

