/*  simtty.c -- monitor terminal simulator for VAX/UNIX
 *  copyright (c)
 *	Dock Wiliams (orignal source courtesy of Daniel Steinberg)
 *	September, 1983
 *
 */

#ifndef DB32

#include <sgtty.h>
#include <signal.h>
#include <stdio.h>

int     oldmask;		/* saved tty info */
struct sgttyb oldparams;
short   savflags;



quitrestore ()
{
    printf("quitrestore\n");
    oldparams.sg_flags = savflags;
    ioctl(0, TIOCSETN, &oldparams);
    ioctl(0, TIOCLSET, &oldmask);
    ioctl(0, TIOCNXCL, NULL);
    exit(0);
}



initty ()
{
    ioctl(0, TIOCEXCL, NULL);		/* get exclusive use */
    ioctl(0, TIOCGETP, &oldparams);	/* get old settings */
    ioctl(0, TIOCLGET, &oldmask);

    savflags = oldparams.sg_flags;
    oldparams.sg_flags |= RAW;
    oldparams.sg_flags &= ~ECHO;
    ioctl(0, TIOCSETP, &oldparams);

    sigsys(SIGQUIT, quitrestore);	/* set restore routine address */
}

#endif
